/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.utils.XmlParserException;
import org.sonar.api.utils.XpathParser;
import org.w3c.dom.Element;

public class XpathParserTest {
    @Test
    public void parseXml() {
        InputStream xml = this.getClass().getResourceAsStream("/org/sonar/api/utils/XpathParserTest/sample.xml");
        try {
            XpathParser parser = new XpathParser();
            parser.parse(xml);
            Assert.assertThat((Object)parser.getRoot().getNodeName(), (Matcher)Is.is((Object)"samples"));
            Assert.assertThat((Object)parser.getChildElements("sample").size(), (Matcher)Is.is((Object)2));
            Assert.assertThat((Object)((Element)parser.getChildElements("sample").get(0)).getAttribute("name"), (Matcher)Is.is((Object)"one"));
            Assert.assertThat((Object)((Element)parser.getChildElements("sample").get(1)).getAttribute("name"), (Matcher)Is.is((Object)"two"));
        }
        finally {
            IOUtils.closeQuietly((InputStream)xml);
        }
    }

    @Test(expected=XmlParserException.class)
    public void unvalidXml() {
        InputStream xml = this.getClass().getResourceAsStream("/org/sonar/api/utils/XpathParserTest/unvalid.xml");
        try {
            XpathParser parser = new XpathParser();
            parser.parse(xml);
        }
        finally {
            IOUtils.closeQuietly((InputStream)xml);
        }
    }
}

