/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.utils.WorkUnit;

public class WorkUnitTest {
    @Test
    public void create() {
        WorkUnit workUnit = WorkUnit.create((Double)2.0, (String)"mn");
        Assertions.assertThat((String)workUnit.getUnit()).isEqualTo((Object)"mn");
        Assertions.assertThat((double)workUnit.getValue()).isEqualTo(2.0);
    }

    @Test
    public void create_default() {
        WorkUnit workUnit = WorkUnit.create();
        Assertions.assertThat((String)workUnit.getUnit()).isEqualTo((Object)"d");
        Assertions.assertThat((double)workUnit.getValue()).isEqualTo(0.0);
    }

    @Test
    public void test_equals() throws Exception {
        Assertions.assertThat((Object)WorkUnit.create((Double)2.0, (String)"mn")).isEqualTo((Object)WorkUnit.create((Double)2.0, (String)"mn"));
        Assertions.assertThat((Object)WorkUnit.create((Double)3.0, (String)"mn")).isNotEqualTo((Object)WorkUnit.create((Double)2.0, (String)"mn"));
        Assertions.assertThat((Object)WorkUnit.create((Double)2.0, (String)"h")).isNotEqualTo((Object)WorkUnit.create((Double)2.0, (String)"mn"));
    }

    @Test
    public void fail_with_bad_unit() {
        try {
            WorkUnit.create((Double)2.0, (String)"z");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }

    @Test
    public void fail_with_bad_value() {
        try {
            WorkUnit.create((Double)-2.0, (String)"mn");
        }
        catch (Exception e) {
            Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class);
        }
    }
}

