/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.utils.WildcardPattern;

public class WildcardPatternTest {
    private boolean match(String pattern, String value, String separator) {
        return new WildcardPattern(pattern, separator).match(value);
    }

    private boolean match(String pattern, String value) {
        return new WildcardPattern(pattern, "/").match(value);
    }

    @Test
    public void examples() {
        Assert.assertTrue((boolean)this.match("org/T?st.java", "org/Test.java"));
        Assert.assertTrue((boolean)this.match("org/T?st.java", "org/Tost.java"));
        Assert.assertTrue((boolean)this.match("org/*.java", "org/Foo.java"));
        Assert.assertTrue((boolean)this.match("org/*.java", "org/Bar.java"));
        Assert.assertTrue((boolean)this.match("org/**", "org/Foo.java"));
        Assert.assertTrue((boolean)this.match("org/**", "org/foo/bar.jsp"));
        Assert.assertTrue((boolean)this.match("org/**/Test.java", "org/Test.java"));
        Assert.assertTrue((boolean)this.match("org/**/Test.java", "org/foo/Test.java"));
        Assert.assertTrue((boolean)this.match("org/**/Test.java", "org/foo/bar/Test.java"));
        Assert.assertTrue((boolean)this.match("org/**/*.java", "org/Foo.java"));
        Assert.assertTrue((boolean)this.match("org/**/*.java", "org/foo/Bar.java"));
        Assert.assertTrue((boolean)this.match("org/**/*.java", "org/foo/bar/Baz.java"));
    }

    @Test
    public void javaResourcesShouldMatchWildcards() {
        Assert.assertTrue((boolean)this.match("Foo", "Foo", "."));
        Assert.assertFalse((boolean)this.match("Foo", "Bar", "."));
        Assert.assertTrue((boolean)this.match("org/sonar/**", "org.sonar.commons.Foo", "."));
        Assert.assertTrue((boolean)this.match("org/sonar/**", "org.sonar.Foo", "."));
        Assert.assertFalse((boolean)this.match("xxx/org/sonar/**", "org.sonar.Foo", "."));
        Assert.assertTrue((boolean)this.match("org/sonar/**/**", "org.sonar.commons.Foo", "."));
        Assert.assertTrue((boolean)this.match("org/sonar/**/**", "org.sonar.commons.sub.Foo", "."));
        Assert.assertTrue((boolean)this.match("org/sonar/**/Foo", "org.sonar.commons.sub.Foo", "."));
        Assert.assertTrue((boolean)this.match("org/sonar/**/Foo", "org.sonar.Foo", "."));
        Assert.assertTrue((boolean)this.match("*/foo/*", "org.foo.Bar", "."));
        Assert.assertFalse((boolean)this.match("*/foo/*", "foo.Bar", "."));
        Assert.assertFalse((boolean)this.match("*/foo/*", "foo", "."));
        Assert.assertFalse((boolean)this.match("*/foo/*", "org.foo.bar.Hello", "."));
        Assert.assertTrue((boolean)this.match("hell?", "hello", "."));
        Assert.assertFalse((boolean)this.match("hell?", "helloworld", "."));
        Assert.assertFalse((boolean)this.match("hell?", "hell", "."));
        Assert.assertTrue((boolean)this.match("a.b.c", "a.b.c", "."));
        Assert.assertTrue((boolean)this.match("*/a.b.c", "foo.a.b.c", "."));
        Assert.assertFalse((boolean)this.match("*/a.b.c", "foo/aabbc", "."));
        Assert.assertTrue((boolean)this.match("**/Reader", "java.io.Reader", "."));
        Assert.assertFalse((boolean)this.match("**/Reader", "org.sonar.channel.CodeReader", "."));
        Assert.assertTrue((boolean)this.match("**", "java.io.Reader", "."));
    }

    @Test
    public void directoriesShouldMatchWildcards() {
        Assert.assertTrue((boolean)this.match("Foo", "Foo"));
        Assert.assertFalse((boolean)this.match("Foo", "Bar"));
        Assert.assertTrue((boolean)this.match("org/sonar/**", "org/sonar/commons/Foo"));
        Assert.assertTrue((boolean)this.match("org/sonar/**", "org/sonar/Foo.java"));
        Assert.assertFalse((boolean)this.match("xxx/org/sonar/**", "org/sonar/Foo"));
        Assert.assertTrue((boolean)this.match("org/sonar/**/**", "org/sonar/commons/Foo"));
        Assert.assertTrue((boolean)this.match("org/sonar/**/**", "org/sonar/commons/sub/Foo.java"));
        Assert.assertTrue((boolean)this.match("org/sonar/**/Foo", "org/sonar/commons/sub/Foo"));
        Assert.assertTrue((boolean)this.match("org/sonar/**/Foo", "org/sonar/Foo"));
        Assert.assertTrue((boolean)this.match("*/foo/*", "org/foo/Bar"));
        Assert.assertFalse((boolean)this.match("*/foo/*", "foo/Bar"));
        Assert.assertFalse((boolean)this.match("*/foo/*", "foo"));
        Assert.assertFalse((boolean)this.match("*/foo/*", "org/foo/bar/Hello"));
        Assert.assertTrue((boolean)this.match("hell?", "hello"));
        Assert.assertFalse((boolean)this.match("hell?", "helloworld"));
        Assert.assertFalse((boolean)this.match("hell?", "hell"));
        Assert.assertTrue((boolean)this.match("a.b.c", "a.b.c"));
        Assert.assertTrue((boolean)this.match("*/a.b.c", "foo/a.b.c"));
        Assert.assertFalse((boolean)this.match("*/a.b.c", "foo/aabbc"));
        Assert.assertTrue((boolean)this.match("**/Reader", "java/io/Reader"));
        Assert.assertFalse((boolean)this.match("**/Reader", "org/sonar/channel/CodeReader"));
        Assert.assertTrue((boolean)this.match("**", "java/io/Reader"));
    }

    @Test
    public void issue2193() {
        Assert.assertTrue((boolean)this.match("**/app/**", "com.app.Utils", "."));
        Assert.assertFalse((boolean)this.match("**/app/**", "com.application.MyService", "."));
        Assert.assertTrue((boolean)this.match("**/app/**", "com/app/Utils"));
        Assert.assertFalse((boolean)this.match("**/app/**", "com/application/MyService"));
    }

    @Test
    public void shouldEscapeRegexpSpecificCharacters() {
        Assert.assertFalse((boolean)this.match("**/*$*", "foo/bar"));
        Assert.assertTrue((boolean)this.match("**/*$*", "foo/bar$baz"));
        Assert.assertFalse((boolean)this.match("a+", "aa"));
        Assert.assertTrue((boolean)this.match("a+", "a+"));
        Assert.assertFalse((boolean)this.match("[ab]", "a"));
        Assert.assertTrue((boolean)this.match("[ab]", "[ab]"));
        Assert.assertTrue((String)"all regexp-specific characters", (boolean)this.match("()[]^$.{}+|", "()[]^$.{}+|"));
    }

    @Test
    public void backslash() {
        Assert.assertFalse((String)"backslash is not an escape character", (boolean)this.match("\\n", "\n"));
        Assert.assertTrue((String)"backslash is the same as forward slash", (boolean)this.match("foo\\bar", "foo/bar"));
    }

    @Test
    public void shouldIgnoreStartingSlash() {
        Assert.assertTrue((boolean)this.match("/foo", "foo"));
        Assert.assertTrue((boolean)this.match("\\foo", "foo"));
    }

    @Test
    public void cornerCase() {
        Assert.assertTrue((boolean)this.match("org/**.*", "org.sonar.commons.Foo.java", "."));
    }

    @Test
    public void multiplePatterns() {
        WildcardPattern[] patterns = WildcardPattern.create((String[])new String[]{"Foo", "Bar"});
        Assert.assertTrue((boolean)WildcardPattern.match((WildcardPattern[])patterns, (String)"Foo"));
        Assert.assertTrue((boolean)WildcardPattern.match((WildcardPattern[])patterns, (String)"Bar"));
        Assert.assertFalse((boolean)WildcardPattern.match((WildcardPattern[])patterns, (String)"Other"));
        Assert.assertThat((Object)WildcardPattern.create((String[])null).length, (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testToString() {
        Assert.assertThat((Object)WildcardPattern.create((String)"foo*").toString(), (Matcher)Matchers.is((Object)"foo*"));
    }
}

