/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.utils.Version;

public class VersionTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void test_parse() {
        VersionTest.assertVersion(Version.parse((String)""), 0, 0, 0, 0L, "");
        VersionTest.assertVersion(Version.parse((String)"1"), 1, 0, 0, 0L, "");
        VersionTest.assertVersion(Version.parse((String)"1.2"), 1, 2, 0, 0L, "");
        VersionTest.assertVersion(Version.parse((String)"1.2.3"), 1, 2, 3, 0L, "");
        VersionTest.assertVersion(Version.parse((String)"1.2-beta-1"), 1, 2, 0, 0L, "beta-1");
        VersionTest.assertVersion(Version.parse((String)"1.2.3-beta1"), 1, 2, 3, 0L, "beta1");
        VersionTest.assertVersion(Version.parse((String)"1.2.3-beta-1"), 1, 2, 3, 0L, "beta-1");
        VersionTest.assertVersion(Version.parse((String)"1.2.3.4567"), 1, 2, 3, 4567L, "");
        VersionTest.assertVersion(Version.parse((String)"1.2.3.4567-alpha"), 1, 2, 3, 4567L, "alpha");
    }

    @Test
    public void parse_throws_IAE_if_more_than_4_fields() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Maximum 4 fields are accepted: 1.2.3.456.7");
        Version.parse((String)"1.2.3.456.7");
    }

    @Test
    public void test_equals() {
        Version one = Version.parse((String)"1");
        Assertions.assertThat((Comparable)one).isEqualTo((Object)one);
        Assertions.assertThat((Comparable)one).isEqualTo((Object)Version.parse((String)"1"));
        Assertions.assertThat((Comparable)one).isEqualTo((Object)Version.parse((String)"1.0"));
        Assertions.assertThat((Comparable)one).isEqualTo((Object)Version.parse((String)"1.0.0"));
        Assertions.assertThat((Comparable)one).isNotEqualTo((Object)Version.parse((String)"1.2.3"));
        Assertions.assertThat((Comparable)one).isNotEqualTo((Object)"1");
        Assertions.assertThat((Comparable)Version.parse((String)"1.2.3")).isEqualTo((Object)Version.parse((String)"1.2.3"));
        Assertions.assertThat((Comparable)Version.parse((String)"1.2.3")).isNotEqualTo((Object)Version.parse((String)"1.2.4"));
        Assertions.assertThat((Comparable)Version.parse((String)"1.2.3")).isEqualTo((Object)Version.parse((String)"1.2.3-b1"));
        Assertions.assertThat((Comparable)Version.parse((String)"1.2.3-b1")).isEqualTo((Object)Version.parse((String)"1.2.3-b2"));
    }

    @Test
    public void test_hashCode() {
        Assertions.assertThat((int)Version.parse((String)"1").hashCode()).isEqualTo(Version.parse((String)"1").hashCode());
        Assertions.assertThat((int)Version.parse((String)"1").hashCode()).isEqualTo(Version.parse((String)"1.0.0").hashCode());
        Assertions.assertThat((int)Version.parse((String)"1.2.3-beta1").hashCode()).isEqualTo(Version.parse((String)"1.2.3").hashCode());
    }

    @Test
    public void test_compareTo() {
        Assertions.assertThat((int)Version.parse((String)"1.2").compareTo(Version.parse((String)"1.2.0"))).isEqualTo(0);
        Assertions.assertThat((int)Version.parse((String)"1.2.3").compareTo(Version.parse((String)"1.2.3"))).isEqualTo(0);
        Assertions.assertThat((int)Version.parse((String)"1.2.3").compareTo(Version.parse((String)"1.2.4"))).isLessThan(0);
        Assertions.assertThat((int)Version.parse((String)"1.2.3").compareTo(Version.parse((String)"1.3"))).isLessThan(0);
        Assertions.assertThat((int)Version.parse((String)"1.2.3").compareTo(Version.parse((String)"2.1"))).isLessThan(0);
        Assertions.assertThat((int)Version.parse((String)"1.2.3").compareTo(Version.parse((String)"2.0.0"))).isLessThan(0);
        Assertions.assertThat((int)Version.parse((String)"2.0").compareTo(Version.parse((String)"1.2"))).isGreaterThan(0);
    }

    @Test
    public void compareTo_handles_build_number() {
        Assertions.assertThat((int)Version.parse((String)"1.2").compareTo(Version.parse((String)"1.2.0.0"))).isEqualTo(0);
        Assertions.assertThat((int)Version.parse((String)"1.2.3.1234").compareTo(Version.parse((String)"1.2.3.4567"))).isLessThan(0);
        Assertions.assertThat((int)Version.parse((String)"1.2.3.1234").compareTo(Version.parse((String)"1.2.3"))).isGreaterThan(0);
        Assertions.assertThat((int)Version.parse((String)"1.2.3.1234").compareTo(Version.parse((String)"1.2.4"))).isLessThan(0);
        Assertions.assertThat((int)Version.parse((String)"1.2.3.9999").compareTo(Version.parse((String)"1.2.4.1111"))).isLessThan(0);
    }

    @Test
    public void qualifier_is_ignored_from_comparison() {
        Assertions.assertThat((Comparable)Version.parse((String)"1.2.3")).isEqualTo((Object)Version.parse((String)"1.2.3-build1"));
        Assertions.assertThat((Comparable)Version.parse((String)"1.2.3")).isEqualTo((Object)Version.parse((String)"1.2.3-build1"));
        Assertions.assertThat((int)Version.parse((String)"1.2.3").compareTo(Version.parse((String)"1.2.3-build1"))).isEqualTo(0);
    }

    @Test
    public void test_toString() {
        Assertions.assertThat((String)Version.parse((String)"1").toString()).isEqualTo((Object)"1.0");
        Assertions.assertThat((String)Version.parse((String)"1.2").toString()).isEqualTo((Object)"1.2");
        Assertions.assertThat((String)Version.parse((String)"1.2.3").toString()).isEqualTo((Object)"1.2.3");
        Assertions.assertThat((String)Version.parse((String)"1.2-b1").toString()).isEqualTo((Object)"1.2-b1");
        Assertions.assertThat((String)Version.parse((String)"1.2.3-b1").toString()).isEqualTo((Object)"1.2.3-b1");
        Assertions.assertThat((String)Version.parse((String)"1.2.3.4567").toString()).isEqualTo((Object)"1.2.3.4567");
        Assertions.assertThat((String)Version.parse((String)"1.2.3.4567-beta1").toString()).isEqualTo((Object)"1.2.3.4567-beta1");
        Assertions.assertThat((String)Version.parse((String)"1.2.0.0").toString()).isEqualTo((Object)"1.2");
        Assertions.assertThat((String)Version.parse((String)"1.2.0.1").toString()).isEqualTo((Object)"1.2.0.1");
        Assertions.assertThat((String)Version.parse((String)"1.2.1.0").toString()).isEqualTo((Object)"1.2.1");
        Assertions.assertThat((String)Version.parse((String)"1.2.1.0-beta").toString()).isEqualTo((Object)"1.2.1-beta");
    }

    @Test
    public void test_create() {
        VersionTest.assertVersion(Version.create((int)1, (int)2), 1, 2, 0, 0L, "");
        VersionTest.assertVersion(Version.create((int)1, (int)2, (int)3), 1, 2, 3, 0L, "");
        VersionTest.assertVersion(Version.create((int)1, (int)2, (int)0, (String)""), 1, 2, 0, 0L, "");
        VersionTest.assertVersion(Version.create((int)1, (int)2, (int)3, (String)"build1"), 1, 2, 3, 0L, "build1");
        Assertions.assertThat((String)Version.create((int)1, (int)2, (int)3, (String)"build1").toString()).isEqualTo((Object)"1.2.3-build1");
    }

    private static void assertVersion(Version version, int expectedMajor, int expectedMinor, int expectedPatch, long expectedBuildNumber, String expectedQualifier) {
        Assertions.assertThat((int)version.major()).isEqualTo(expectedMajor);
        Assertions.assertThat((int)version.minor()).isEqualTo(expectedMinor);
        Assertions.assertThat((int)version.patch()).isEqualTo(expectedPatch);
        Assertions.assertThat((long)version.buildNumber()).isEqualTo(expectedBuildNumber);
        Assertions.assertThat((String)version.qualifier()).isEqualTo((Object)expectedQualifier);
    }
}

