/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.sonar.api.utils.ValidationMessages;
import org.sonar.api.utils.log.Logger;

public class ValidationMessagesTest {
    @Test
    public void emptyMessages() {
        ValidationMessages messages = ValidationMessages.create();
        Assertions.assertThat((boolean)messages.hasErrors()).isFalse();
        Assertions.assertThat((boolean)messages.hasWarnings()).isFalse();
        Assertions.assertThat((boolean)messages.hasInfos()).isFalse();
        Logger logger = (Logger)Mockito.mock(Logger.class);
        messages.log(logger);
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.never())).error(Mockito.anyString());
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.never())).warn(Mockito.anyString());
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.never())).info(Mockito.anyString());
        org.slf4j.Logger slf4j = (org.slf4j.Logger)Mockito.mock(org.slf4j.Logger.class);
        messages.log(slf4j);
        ((org.slf4j.Logger)Mockito.verify((Object)slf4j, (VerificationMode)Mockito.never())).error(Mockito.anyString());
        ((org.slf4j.Logger)Mockito.verify((Object)slf4j, (VerificationMode)Mockito.never())).warn(Mockito.anyString());
        ((org.slf4j.Logger)Mockito.verify((Object)slf4j, (VerificationMode)Mockito.never())).info(Mockito.anyString());
    }

    @Test
    public void addError() {
        ValidationMessages messages = ValidationMessages.create();
        messages.addErrorText("my error");
        Assertions.assertThat((boolean)messages.hasErrors()).isTrue();
        Assertions.assertThat((boolean)messages.hasWarnings()).isFalse();
        Assertions.assertThat((boolean)messages.hasInfos()).isFalse();
        Assertions.assertThat((List)messages.getErrors()).hasSize(1);
        Assertions.assertThat((List)messages.getErrors()).contains((Object[])new String[]{"my error"});
        Assertions.assertThat((String)messages.toString()).contains(new CharSequence[]{"my error"});
        Logger logger = (Logger)Mockito.mock(Logger.class);
        messages.log(logger);
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.times((int)1))).error("my error");
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.never())).warn(Mockito.anyString());
        ((Logger)Mockito.verify((Object)logger, (VerificationMode)Mockito.never())).info(Mockito.anyString());
        org.slf4j.Logger slf4j = (org.slf4j.Logger)Mockito.mock(org.slf4j.Logger.class);
        messages.log(slf4j);
        ((org.slf4j.Logger)Mockito.verify((Object)slf4j, (VerificationMode)Mockito.times((int)1))).error("my error");
        ((org.slf4j.Logger)Mockito.verify((Object)slf4j, (VerificationMode)Mockito.never())).warn(Mockito.anyString());
        ((org.slf4j.Logger)Mockito.verify((Object)slf4j, (VerificationMode)Mockito.never())).info(Mockito.anyString());
    }
}

