/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.sonar.api.utils.UriReader;

public class UriReaderTest {
    private static URI testFile;
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Before
    public void init() throws URISyntaxException {
        testFile = UriReaderTest.class.getResource("/org/sonar/api/utils/UriReaderTest/foo.txt").toURI();
    }

    @Test
    public void file_processor_is_always_available() {
        UriReader uriReader = new UriReader(new UriReader.SchemeProcessor[0]);
        Assertions.assertThat((Object)uriReader.searchForSupportedProcessor(testFile)).isNotNull();
    }

    @Test
    public void file_readString() {
        UriReader uriReader = new UriReader(new UriReader.SchemeProcessor[0]);
        Assertions.assertThat((String)uriReader.readString(testFile, StandardCharsets.UTF_8)).isEqualTo((Object)"in foo");
    }

    @Test
    public void file_readBytes() {
        UriReader uriReader = new UriReader(new UriReader.SchemeProcessor[0]);
        Assertions.assertThat((String)new String(uriReader.readBytes(testFile))).isEqualTo((Object)"in foo");
    }

    @Test
    public void file_readString_fails_if_file_not_found() throws Exception {
        this.thrown.expect(RuntimeException.class);
        UriReader uriReader = new UriReader(new UriReader.SchemeProcessor[0]);
        uriReader.readString(new URI("file:/notfound"), StandardCharsets.UTF_8);
    }

    @Test
    public void file_readBytes_fails_if_file_not_found() throws Exception {
        this.thrown.expect(RuntimeException.class);
        UriReader uriReader = new UriReader(new UriReader.SchemeProcessor[0]);
        uriReader.readBytes(new URI("file:/notfound"));
    }

    @Test
    public void file_description() {
        UriReader uriReader = new UriReader(new UriReader.SchemeProcessor[0]);
        Assertions.assertThat((String)uriReader.description(testFile)).doesNotMatch((CharSequence)"file:/.*");
        Assertions.assertThat((String)uriReader.description(testFile)).matches((CharSequence)".*foo\\.txt");
    }

    @Test
    public void fail_if_unknown_scheme() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        UriReader uriReader = new UriReader(new UriReader.SchemeProcessor[0]);
        uriReader.readBytes(new URI("ftp://sonarsource.org"));
    }

    @Test
    public void register_processors() throws Exception {
        UriReader.SchemeProcessor processor = (UriReader.SchemeProcessor)Mockito.mock(UriReader.SchemeProcessor.class);
        Mockito.when((Object)processor.getSupportedSchemes()).thenReturn((Object)new String[]{"ftp"});
        UriReader uriReader = new UriReader(new UriReader.SchemeProcessor[]{processor});
        Assertions.assertThat((Object)uriReader.searchForSupportedProcessor(new URI("ftp://sonarsource.org"))).isNotNull();
    }
}

