/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.sonar.api.utils.TimeProfiler;

public class TimeProfilerTest {
    private Logger logger;

    @Before
    public void before() {
        this.logger = (Logger)Mockito.mock(Logger.class);
    }

    @Test
    public void testBasicProfiling() {
        TimeProfiler profiler = new TimeProfiler(this.logger);
        profiler.start("Cycle analysis");
        ((Logger)Mockito.verify((Object)this.logger)).info("Cycle analysis...");
        profiler.stop();
        ((Logger)Mockito.verify((Object)this.logger)).info((String)Mockito.eq((Object)"{} done: {} ms"), Mockito.eq((Object)"Cycle analysis"), (Object)Mockito.anyInt());
    }

    @Test
    public void stopOnce() {
        TimeProfiler profiler = new TimeProfiler(this.logger);
        profiler.start("Cycle analysis");
        profiler.stop();
        profiler.stop();
        profiler.stop();
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).info(Mockito.anyString());
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).info(Mockito.anyString(), (Object)Mockito.anyString(), (Object)Mockito.anyInt());
    }

    @Test
    public void doNotLogNeverEndedTask() {
        TimeProfiler profiler = new TimeProfiler(this.logger);
        profiler.start("Cycle analysis");
        profiler.start("New task");
        profiler.stop();
        profiler.stop();
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.never())).info((String)Mockito.eq((Object)"{} done: {} ms"), Mockito.eq((Object)"Cycle analysis"), (Object)Mockito.anyInt());
        ((Logger)Mockito.verify((Object)this.logger, (VerificationMode)Mockito.times((int)1))).info((String)Mockito.eq((Object)"{} done: {} ms"), Mockito.eq((Object)"New task"), (Object)Mockito.anyInt());
    }
}

