/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.lang.SystemUtils;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.utils.System2;

public class System2Test {
    @Test
    public void testNow() throws Exception {
        long start = System.currentTimeMillis();
        long now = System2.INSTANCE.now();
        long end = System.currentTimeMillis();
        Assertions.assertThat((long)now).isGreaterThanOrEqualTo(start).isLessThanOrEqualTo(end);
    }

    @Test
    public void testProperties() throws Exception {
        Properties expected = System.getProperties();
        ((MapAssert)Assertions.assertThat((Map)System2.INSTANCE.properties()).isNotNull()).isEqualTo((Object)expected);
    }

    @Test
    public void testProperty() throws Exception {
        String expected = System.getProperty("java.version");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)System2.INSTANCE.property("java.version")).isNotNull()).isEqualTo((Object)expected);
    }

    @Test
    public void testEnvVariables() throws Exception {
        Map<String, String> expected = System.getenv();
        ((MapAssert)Assertions.assertThat((Map)System2.INSTANCE.envVariables()).isNotNull()).isEqualTo(expected);
    }

    @Test
    public void testEnvVariable() throws Exception {
        if (System.getenv().isEmpty()) {
            Assert.fail((String)"Test can't succeed because there are no env variables. How is it possible ?");
        }
        String key = System.getenv().keySet().iterator().next();
        String expected = System.getenv(key);
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)System2.INSTANCE.envVariable(key)).isNotNull()).isEqualTo((Object)expected);
        Assertions.assertThat((String)System2.INSTANCE.envVariable("UNKNOWN_VAR")).isNull();
    }

    @Test
    public void testIsOsWindows() throws Exception {
        Assertions.assertThat((boolean)System2.INSTANCE.isOsWindows()).isEqualTo(SystemUtils.IS_OS_WINDOWS);
    }

    @Test
    public void testIsJavaAtLeast17() throws Exception {
        if (SystemUtils.IS_JAVA_1_6) {
            Assertions.assertThat((boolean)System2.INSTANCE.isJavaAtLeast17()).isFalse();
        } else {
            Assertions.assertThat((boolean)System2.INSTANCE.isJavaAtLeast17()).isTrue();
        }
    }

    @Test
    public void testPrintln() throws Exception {
        System2.INSTANCE.println("foo");
    }

    @Test
    public void testGetResource() throws Exception {
        String name = "META-INF/MANIFEST.MF";
        Assertions.assertThat((URL)System2.INSTANCE.getResource(name)).isEqualTo((Object)this.getClass().getResource(name));
    }

    @Test
    public void close() {
        class MyCloseable
        implements Closeable {
            boolean isClosed = false;

            MyCloseable() {
            }

            @Override
            public void close() throws IOException {
                this.isClosed = true;
            }
        }
        MyCloseable closeable = new MyCloseable();
        System2.INSTANCE.close((AutoCloseable)closeable);
        Assertions.assertThat((boolean)closeable.isClosed).isTrue();
    }

    @Test
    public void close_throws_exception_on_error() {
        Closeable closeable = new Closeable(){

            @Override
            public void close() throws IOException {
                throw new IOException("expected");
            }
        };
        try {
            System2.INSTANCE.close((AutoCloseable)closeable);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((String)e.getCause().getMessage()).isEqualTo((Object)"expected");
        }
    }

    @Test
    public void getDefaultTimezone() {
        Assertions.assertThat((String)System2.INSTANCE.getDefaultTimeZone().getID()).isEqualTo((Object)TimeZone.getDefault().getID());
    }
}

