/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mockito.Mockito;
import org.sonar.api.utils.PathUtils;
import org.sonar.test.TestUtils;

public class PathUtilsTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testSanitize() throws Exception {
        Assertions.assertThat((String)PathUtils.sanitize((String)"foo/bar/..")).isEqualTo((Object)"foo/");
        Assertions.assertThat((String)PathUtils.sanitize((String)"C:\\foo\\..\\bar")).isEqualTo((Object)"C:/bar");
        Assertions.assertThat((String)PathUtils.sanitize(null)).isNull();
    }

    @Test
    public void test_canonicalPath() throws Exception {
        File file = this.temp.newFile();
        String path = PathUtils.canonicalPath((File)file);
        Assertions.assertThat((String)path).isEqualTo((Object)FilenameUtils.separatorsToUnix((String)file.getCanonicalPath()));
    }

    @Test
    public void canonicalPath_returns_null_if_null_input() {
        Assertions.assertThat((String)PathUtils.canonicalPath(null)).isNull();
    }

    @Test
    public void canonicalPath_fails_to_get_canonical_path() throws Exception {
        File file = (File)Mockito.mock(File.class);
        Mockito.when((Object)file.getCanonicalPath()).thenThrow(new Throwable[]{new IOException()});
        try {
            PathUtils.canonicalPath((File)file);
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e.getCause()).isInstanceOf(IOException.class);
        }
    }

    @Test
    public void only_statics() {
        Assertions.assertThat((boolean)TestUtils.hasOnlyPrivateConstructors(PathUtils.class)).isTrue();
    }
}

