/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.utils.Paging;

public class PagingTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void test_pagination() {
        Paging paging = Paging.forPageIndex((int)1).withPageSize(5).andTotal(20);
        Assertions.assertThat((int)paging.pageSize()).isEqualTo(5);
        Assertions.assertThat((int)paging.pageIndex()).isEqualTo(1);
        Assertions.assertThat((int)paging.total()).isEqualTo(20);
        Assertions.assertThat((int)paging.offset()).isEqualTo(0);
        Assertions.assertThat((int)paging.pages()).isEqualTo(4);
    }

    @Test
    public void test_offset() {
        Assertions.assertThat((int)Paging.forPageIndex((int)1).withPageSize(5).andTotal(20).offset()).isEqualTo(0);
        Assertions.assertThat((int)Paging.forPageIndex((int)2).withPageSize(5).andTotal(20).offset()).isEqualTo(5);
    }

    @Test
    public void test_number_of_pages() {
        Assertions.assertThat((int)Paging.forPageIndex((int)2).withPageSize(5).andTotal(20).pages()).isEqualTo(4);
        Assertions.assertThat((int)Paging.forPageIndex((int)2).withPageSize(5).andTotal(21).pages()).isEqualTo(5);
        Assertions.assertThat((int)Paging.forPageIndex((int)2).withPageSize(5).andTotal(25).pages()).isEqualTo(5);
        Assertions.assertThat((int)Paging.forPageIndex((int)2).withPageSize(5).andTotal(26).pages()).isEqualTo(6);
    }

    @Test
    public void page_size_should_be_strictly_positive() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Page size must be strictly positive. Got 0");
        Paging.forPageIndex((int)5).withPageSize(0).andTotal(5);
    }

    @Test
    public void page_index_should_be_strictly_positive() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Page index must be strictly positive. Got 0");
        Paging.forPageIndex((int)0).withPageSize(5).andTotal(5);
    }

    @Test
    public void total_items_should_be_positive() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Total items must be positive. Got -1");
        Paging.forPageIndex((int)5).withPageSize(5).andTotal(-1);
    }
}

