/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.utils.MessageException;

public class MessageExceptionTest {
    @Test
    public void should_create_exception() {
        String message = "the message";
        MessageException exception = MessageException.of((String)message);
        Assertions.assertThat((String)exception.getMessage()).isEqualTo((Object)message);
        Assertions.assertThat((Throwable)exception).isInstanceOf(RuntimeException.class);
    }

    @Test
    public void should_create_exception_with_status_and_l10n_message_with_param() {
        MessageException exception = MessageException.ofL10n((String)"key", (Object[])new String[]{"value"});
        Assertions.assertThat((String)exception.l10nKey()).isEqualTo((Object)"key");
        Assertions.assertThat((Iterable)exception.l10nParams()).containsOnly(new Object[]{"value"});
    }

    @Test
    public void should_create_exception_with_status_and_l10n_message_without_param() {
        MessageException exception = MessageException.ofL10n((String)"key", null);
        Assertions.assertThat((String)exception.l10nKey()).isEqualTo((Object)"key");
        Assertions.assertThat((Iterable)exception.l10nParams()).isEmpty();
    }
}

