/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.sonar.api.utils.ManifestUtils;

public class ManifestUtilsTest {
    @Rule
    public TemporaryFolder tempDir = new TemporaryFolder();

    @Test
    public void emptyManifest() throws Exception {
        Manifest mf = new Manifest();
        File jar = this.createJar(mf, "emptyManifest.jar");
        URLClassLoader classloader = new URLClassLoader(FileUtils.toURLs((File[])new File[]{jar}));
        Assertions.assertThat((List)ManifestUtils.getPropertyValues((ClassLoader)classloader, (String)"foo")).isEmpty();
    }

    @Test
    public void singleManifest() throws Exception {
        Manifest mf = new Manifest();
        mf.getMainAttributes().putValue("foo", "bar");
        mf.getMainAttributes().putValue("other", "value");
        File jar = this.createJar(mf, "singleManifest.jar");
        URLClassLoader classloader = new URLClassLoader(FileUtils.toURLs((File[])new File[]{jar}));
        List values = ManifestUtils.getPropertyValues((ClassLoader)classloader, (String)"foo");
        Assertions.assertThat((List)values).containsOnly((Object[])new String[]{"bar"});
    }

    @Test
    public void manyManifests() throws Exception {
        Manifest mf1 = new Manifest();
        mf1.getMainAttributes().putValue("foo", "bar");
        File jar1 = this.createJar(mf1, "manyManifests-one.jar");
        Manifest mf2 = new Manifest();
        mf2.getMainAttributes().putValue("foo", "otherbar");
        File jar2 = this.createJar(mf2, "manyManifests-two.jar");
        URLClassLoader classloader = new URLClassLoader(FileUtils.toURLs((File[])new File[]{jar1, jar2}));
        List values = ManifestUtils.getPropertyValues((ClassLoader)classloader, (String)"foo");
        Assertions.assertThat((List)values).containsOnly((Object[])new String[]{"bar", "otherbar"});
    }

    private File createJar(Manifest mf, String name) throws Exception {
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        File file = this.tempDir.newFile(name);
        JarOutputStream out = new JarOutputStream((OutputStream)new FileOutputStream(file), mf);
        ((OutputStream)out).flush();
        IOUtils.closeQuietly((OutputStream)out);
        return file;
    }
}

