/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.sonar.api.utils.LocalizedMessages;

public class LocalizedMessagesTest {
    private static final Locale DEFAULT_LOCALE = Locale.getDefault();

    @BeforeClass
    public static void beforeAll() {
        Locale.setDefault(Locale.ENGLISH);
    }

    @AfterClass
    public static void afterAll() {
        Locale.setDefault(DEFAULT_LOCALE);
    }

    @Test
    public void mergeBundles() {
        LocalizedMessages messages = new LocalizedMessages(Locale.ENGLISH, new String[]{"Test", "PluginFoo"});
        Assert.assertThat((Object)messages.getString("test.one"), (Matcher)Matchers.is((Object)"One"));
        Assert.assertThat((Object)messages.getString("test.two"), (Matcher)Matchers.is((Object)"Two"));
        Assert.assertThat((Object)messages.getString("foo.hello"), (Matcher)Matchers.is((Object)"Hello"));
    }

    @Test
    public void mergeBundlesByLocale() {
        LocalizedMessages messages = new LocalizedMessages(Locale.FRENCH, new String[]{"Test", "PluginFoo"});
        Assert.assertThat((Object)messages.getString("test.one"), (Matcher)Matchers.is((Object)"Un"));
        Assert.assertThat((Object)messages.getString("test.two"), (Matcher)Matchers.is((Object)"Deux"));
        Assert.assertThat((Object)messages.getString("foo.hello"), (Matcher)Matchers.is((Object)"Hello"));
    }

    @Test
    public void useDefaultWhenMissingLocale() {
        LocalizedMessages messages = new LocalizedMessages(Locale.JAPANESE, new String[]{"Test", "PluginFoo"});
        Assert.assertThat((Object)messages.getString("test.one"), (Matcher)Matchers.is((Object)"One"));
        Assert.assertThat((Object)messages.getString("foo.hello"), (Matcher)Matchers.is((Object)"Hello"));
    }

    @Test(expected=MissingResourceException.class)
    public void failIfMissingKey() {
        LocalizedMessages messages = new LocalizedMessages(Locale.FRENCH, new String[]{"Test", "PluginFoo"});
        messages.getString("unknown");
    }

    @Test
    public void format() {
        LocalizedMessages messages = new LocalizedMessages(Locale.ENGLISH, new String[]{"Test", "PluginFoo"});
        Assert.assertThat((Object)messages.format("test.one", new Object[0]), (Matcher)Matchers.is((Object)"One"));
    }

    @Test
    public void formatNeverFails() {
        LocalizedMessages messages = new LocalizedMessages(Locale.ENGLISH, new String[]{"Test", "PluginFoo"});
        Assert.assertThat((Object)messages.format("unknown", new Object[0]), (Matcher)Matchers.is((Object)"unknown"));
    }

    @Test
    public void formatParameters() {
        LocalizedMessages messages = new LocalizedMessages(Locale.ENGLISH, new String[]{"Test", "PluginFoo"});
        Assert.assertThat((Object)messages.format("with.string.params", new Object[]{"inspection", "rock"}), (Matcher)Matchers.is((Object)"Continuous inspection will rock !"));
        Assert.assertThat((Object)messages.format("with.string.params", new Object[]{"rock", "inspection"}), (Matcher)Matchers.is((Object)"Continuous rock will inspection !"));
    }

    @Test
    public void getKeys() {
        LocalizedMessages messages = new LocalizedMessages(Locale.ENGLISH, new String[]{"Test", "PluginFoo"});
        Assert.assertThat(this.toList(messages.getKeys()), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{"test.one", "test.two", "foo.hello"}));
        LocalizedMessages spanishMessages = new LocalizedMessages(new Locale("es"), new String[]{"Test", "PluginFoo"});
        Assert.assertThat(this.toList(spanishMessages.getKeys()), (Matcher)JUnitMatchers.hasItems((Object[])new String[]{"test.one", "only.in.spanish"}));
    }

    private List<String> toList(Enumeration<String> enumeration) {
        return Lists.newArrayList((Iterator)Iterators.forEnumeration(enumeration));
    }
}

