/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.google.common.collect.ImmutableMap;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.KeyValueFormat;
import org.sonar.test.TestUtils;

public class KeyValueFormatTest {
    @Test
    public void test_parser() throws Exception {
        KeyValueFormat.FieldParser reader = new KeyValueFormat.FieldParser("abc=def;ghi=jkl");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"abc");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"def");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"ghi");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"jkl");
        Assertions.assertThat((String)reader.nextKey()).isNull();
        reader = new KeyValueFormat.FieldParser("abc=1;ghi=2");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"abc");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"1");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"ghi");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"2");
        Assertions.assertThat((String)reader.nextKey()).isNull();
        reader = new KeyValueFormat.FieldParser("abc=;ghi=jkl");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"abc");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"ghi");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"jkl");
        Assertions.assertThat((String)reader.nextKey()).isNull();
        reader = new KeyValueFormat.FieldParser("abc=def");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"abc");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"def");
        Assertions.assertThat((String)reader.nextKey()).isNull();
        reader = new KeyValueFormat.FieldParser("abc=\"def\";ghi=\"jkl\"");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"abc");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"def");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"ghi");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"jkl");
        Assertions.assertThat((String)reader.nextKey()).isNull();
        reader = new KeyValueFormat.FieldParser("\"abc\"=\"def\";\"ghi\"=\"jkl\"");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"abc");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"def");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"ghi");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"jkl");
        Assertions.assertThat((String)reader.nextKey()).isNull();
        reader = new KeyValueFormat.FieldParser("abc=\"def\\\"ghi\"");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"abc");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"def\"ghi");
        Assertions.assertThat((String)reader.nextKey()).isNull();
        reader = new KeyValueFormat.FieldParser("");
        Assertions.assertThat((String)reader.nextKey()).isNull();
        reader = new KeyValueFormat.FieldParser("abc=;def=");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"abc");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"def");
        Assertions.assertThat((String)reader.nextVal()).isNull();
        reader = new KeyValueFormat.FieldParser("abc=\"1=2;3\";def=\"4;5=6\"");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"abc");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"1=2;3");
        Assertions.assertThat((String)reader.nextKey()).isEqualTo((Object)"def");
        Assertions.assertThat((String)reader.nextVal()).isEqualTo((Object)"4;5=6");
        Assertions.assertThat((String)reader.nextKey()).isNull();
    }

    @Test
    public void keep_order_of_linked_map() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("lucky", "luke");
        map.put("aste", "rix");
        String s = KeyValueFormat.format(map);
        Assertions.assertThat((String)s).isEqualTo((Object)"lucky=luke;aste=rix");
    }

    @Test
    public void shouldFormatMapOfIntegerString() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        map.put(3, "three");
        map.put(5, "five");
        String s = KeyValueFormat.formatIntString(map);
        Assertions.assertThat((String)s).isEqualTo((Object)"3=three;5=five");
    }

    @Test
    public void shouldFormatMapOfIntDouble() {
        LinkedHashMap<Integer, Double> map = new LinkedHashMap<Integer, Double>();
        map.put(13, 2.0);
        map.put(5, 5.75);
        String s = KeyValueFormat.formatIntDouble(map);
        Assertions.assertThat((String)s).isEqualTo((Object)"13=2.0;5=5.75");
    }

    @Test
    public void shouldSetEmptyFieldWhenNullValue() {
        LinkedHashMap<Integer, Double> map = new LinkedHashMap<Integer, Double>();
        map.put(13, null);
        map.put(5, 5.75);
        String s = KeyValueFormat.formatIntDouble(map);
        Assertions.assertThat((String)s).isEqualTo((Object)"13=;5=5.75");
    }

    @Test
    public void shouldFormatBlank() {
        TreeMap map = new TreeMap();
        String s = KeyValueFormat.formatIntString(map);
        Assertions.assertThat((String)s).isEqualTo((Object)"");
    }

    @Test
    public void shouldFormatDate() throws ParseException {
        LinkedHashMap<Integer, Date> map = new LinkedHashMap<Integer, Date>();
        map.put(4, new SimpleDateFormat("yyyy-MM-dd").parse("2010-12-25"));
        map.put(20, new SimpleDateFormat("yyyy-MM-dd").parse("2009-05-28"));
        map.put(12, null);
        String s = KeyValueFormat.formatIntDate(map);
        Assertions.assertThat((String)s).isEqualTo((Object)"4=2010-12-25;20=2009-05-28;12=");
    }

    @Test
    public void shouldParseStrings() {
        Map map = KeyValueFormat.parse((String)"one=un;two=deux");
        Assertions.assertThat((int)map.size()).isEqualTo(2);
        Assertions.assertThat((String)((String)map.get("one"))).isEqualTo((Object)"un");
        Assertions.assertThat((String)((String)map.get("two"))).isEqualTo((Object)"deux");
        Assertions.assertThat((String)((String)map.keySet().iterator().next())).isEqualTo((Object)"one");
    }

    @Test
    public void helper_parse_methods() {
        Assertions.assertThat((Map)KeyValueFormat.parseIntDate((String)"1=2014-01-15")).hasSize(1);
        Assertions.assertThat((Map)KeyValueFormat.parseIntDateTime((String)"1=2014-01-15T15:50:45+0100")).hasSize(1);
        Assertions.assertThat((Map)KeyValueFormat.parseIntDouble((String)"1=3.14")).hasSize(1);
        Assertions.assertThat((Map)KeyValueFormat.parseIntInt((String)"1=10")).containsOnly(new Map.Entry[]{Assertions.entry((Object)1, (Object)10)});
        Assertions.assertThat((Map)KeyValueFormat.parseIntString((String)"1=one")).containsOnly(new Map.Entry[]{Assertions.entry((Object)1, (Object)"one")});
        Assertions.assertThat((Map)KeyValueFormat.parseIntString((String)"1=\"escaped\"")).containsOnly(new Map.Entry[]{Assertions.entry((Object)1, (Object)"escaped")});
        Assertions.assertThat((Map)KeyValueFormat.parseStringInt((String)"one=1")).containsOnly(new Map.Entry[]{Assertions.entry((Object)"one", (Object)1)});
        Assertions.assertThat((Map)KeyValueFormat.parseStringDouble((String)"pi=3.14")).containsOnly(new Map.Entry[]{Assertions.entry((Object)"pi", (Object)3.14)});
    }

    @Test
    public void helper_format_methods() {
        Assertions.assertThat((String)KeyValueFormat.formatIntDateTime((Map)ImmutableMap.of((Object)1, (Object)new Date()))).startsWith((CharSequence)"1=");
        Assertions.assertThat((String)KeyValueFormat.formatIntDate((Map)ImmutableMap.of((Object)1, (Object)new Date()))).startsWith((CharSequence)"1=");
        Assertions.assertThat((String)KeyValueFormat.formatIntDouble((Map)ImmutableMap.of((Object)1, (Object)3.14))).startsWith((CharSequence)"1=");
        Assertions.assertThat((String)KeyValueFormat.formatIntString((Map)ImmutableMap.of((Object)1, (Object)"one"))).isEqualTo((Object)"1=one");
        Assertions.assertThat((String)KeyValueFormat.formatStringInt((Map)ImmutableMap.of((Object)"one", (Object)1))).isEqualTo((Object)"one=1");
    }

    @Test
    public void parse_blank() {
        Map map = KeyValueFormat.parse((String)"");
        Assertions.assertThat((Map)map).isEmpty();
    }

    @Test
    public void parse_null() {
        Map map = KeyValueFormat.parse(null);
        Assertions.assertThat((Map)map).isEmpty();
    }

    @Test
    public void parse_empty_values() {
        Map map = KeyValueFormat.parseIntDouble((String)"4=4.2;2=;6=6.68");
        Assertions.assertThat((int)map.size()).isEqualTo(3);
        Assertions.assertThat((Double)((Double)map.get(4))).isEqualTo(4.2);
        Assertions.assertThat((boolean)map.containsKey(2)).isTrue();
        Assertions.assertThat((Double)((Double)map.get(2))).isNull();
        Assertions.assertThat((Double)((Double)map.get(6))).isEqualTo(6.68);
    }

    @Test
    public void convert_deprecated_priority() {
        Assertions.assertThat((String)KeyValueFormat.newPriorityConverter().format(RulePriority.BLOCKER)).isEqualTo((Object)"BLOCKER");
        Assertions.assertThat((String)KeyValueFormat.newPriorityConverter().format(null)).isEqualTo((Object)"");
        Assertions.assertThat((Comparable)KeyValueFormat.newPriorityConverter().parse("MAJOR")).isEqualTo((Object)RulePriority.MAJOR);
        Assertions.assertThat((Comparable)KeyValueFormat.newPriorityConverter().parse("")).isNull();
    }

    @Test
    public void escape_strings() {
        LinkedHashMap<String, String> input = new LinkedHashMap<String, String>();
        input.put("foo", "a=b=c");
        input.put("bar", "a;b;c");
        input.put("baz", "double\"quote");
        String csv = KeyValueFormat.format(input);
        Assertions.assertThat((String)csv).isEqualTo((Object)"foo=\"a=b=c\";bar=\"a;b;c\";baz=double\"quote");
        Map output = KeyValueFormat.parse((String)csv);
        Assertions.assertThat((String)((String)output.get("foo"))).isEqualTo((Object)"a=b=c");
        Assertions.assertThat((String)((String)output.get("bar"))).isEqualTo((Object)"a;b;c");
        Assertions.assertThat((String)((String)output.get("baz"))).isEqualTo((Object)"double\"quote");
    }

    @Test
    public void not_instantiable() {
        TestUtils.hasOnlyPrivateConstructors(KeyValueFormat.class);
    }
}

