/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.utils.FieldUtils2;

public class FieldUtils2Test {
    @Test
    public void shouldGetFieldsOfSingleClass() {
        List<String> fields = FieldUtils2Test.fieldsName(FieldUtils2.getFields(FieldsWithDifferentModifiers.class, (boolean)true));
        Assertions.assertThat(fields).contains((Object[])new String[]{"publicField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"protectedField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"packageField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"privateField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"publicStaticField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"protectedStaticField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"packageStaticField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"privateStaticField"});
    }

    @Test
    public void shouldGetFieldsOfClassHierarchy() {
        List<String> fields = FieldUtils2Test.fieldsName(FieldUtils2.getFields(Child.class, (boolean)true));
        Assertions.assertThat(fields).contains((Object[])new String[]{"publicField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"protectedField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"packageField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"privateField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"publicStaticField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"protectedStaticField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"packageStaticField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"privateStaticField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"childPrivateField"});
    }

    @Test
    public void shouldGetOnlyAccessibleFields() {
        List<String> fields = FieldUtils2Test.fieldsName(FieldUtils2.getFields(Child.class, (boolean)false));
        Assertions.assertThat(fields).contains((Object[])new String[]{"publicField"});
        Assertions.assertThat(fields).contains((Object[])new String[]{"publicStaticField"});
    }

    @Test
    public void shouldGetFieldsOfInterface() {
        List<String> fields = FieldUtils2Test.fieldsName(FieldUtils2.getFields(InterfaceWithFields.class, (boolean)true));
        Assertions.assertThat(fields).contains((Object[])new String[]{"INTERFACE_FIELD"});
    }

    @Test
    public void shouldGetFieldsOfInterfaceImplementation() {
        List<String> fields = FieldUtils2Test.fieldsName(FieldUtils2.getFields(InterfaceImplementation.class, (boolean)true));
        Assertions.assertThat(fields).contains((Object[])new String[]{"INTERFACE_FIELD"});
    }

    private static List<String> fieldsName(List<Field> fields) {
        return Lists.newArrayList((Iterable)Iterables.transform(fields, (Function)new Function<Field, String>(){

            public String apply(@Nullable Field input) {
                return input != null ? input.getName() : null;
            }
        }));
    }

    static class Child
    extends FieldsWithDifferentModifiers {
        private String childPrivateField;

        Child() {
        }
    }

    static class FieldsWithDifferentModifiers {
        public String publicField;
        protected String protectedField;
        String packageField;
        private String privateField;
        public static String publicStaticField;
        protected static String protectedStaticField;
        static String packageStaticField;
        private static String privateStaticField;

        FieldsWithDifferentModifiers() {
        }
    }

    static class InterfaceImplementation
    implements InterfaceWithFields {
        InterfaceImplementation() {
        }
    }

    static interface InterfaceWithFields {
        public static final String INTERFACE_FIELD = "foo";
    }
}

