/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.utils.Duration;
import org.sonar.api.utils.Durations;

public class DurationsTest {
    private static final int HOURS_IN_DAY = 8;
    private static final long ONE_MINUTE = 1L;
    private static final long ONE_HOUR = 60L;
    private static final long ONE_DAY = 480L;
    private Durations underTest = new Durations();

    @Test
    public void create_from_minutes() {
        Assertions.assertThat((long)this.underTest.create(10L).toMinutes()).isEqualTo(10L);
    }

    @Test
    public void decode() {
        Assertions.assertThat((long)this.underTest.decode("1d").toMinutes()).isEqualTo(480L);
        Assertions.assertThat((long)this.underTest.decode("8h").toMinutes()).isEqualTo(480L);
    }

    @Test
    public void format() {
        Assertions.assertThat((String)this.underTest.format(Duration.create((long)2400L))).isEqualTo((Object)"5d");
        Assertions.assertThat((String)this.underTest.format(Duration.create((long)120L))).isEqualTo((Object)"2h");
        Assertions.assertThat((String)this.underTest.format(Duration.create((long)1L))).isEqualTo((Object)"1min");
        Assertions.assertThat((String)this.underTest.format(Duration.create((long)2520L))).isEqualTo((Object)"5d 2h");
        Assertions.assertThat((String)this.underTest.format(Duration.create((long)121L))).isEqualTo((Object)"2h 1min");
        Assertions.assertThat((String)this.underTest.format(Duration.create((long)2521L))).isEqualTo((Object)"5d 2h");
    }

    @Test
    public void not_display_following_element_when_bigger_than_ten() {
        Assertions.assertThat((String)this.underTest.format(Duration.create((long)7621L))).isEqualTo((Object)"15d");
    }

    @Test
    public void display_zero_without_unit() {
        Assertions.assertThat((String)this.underTest.format(Duration.create((long)0L))).isEqualTo((Object)"0");
    }

    @Test
    public void display_negative_duration() {
        Assertions.assertThat((String)this.underTest.format(Duration.create((long)-2400L))).isEqualTo((Object)"-5d");
        Assertions.assertThat((String)this.underTest.format(Duration.create((long)-120L))).isEqualTo((Object)"-2h");
        Assertions.assertThat((String)this.underTest.format(Duration.create((long)-1L))).isEqualTo((Object)"-1min");
    }
}

