/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.utils.Duration;

public class DurationTest {
    static final int HOURS_IN_DAY = 8;
    static final Long ONE_MINUTE = 1L;
    static final Long ONE_HOUR_IN_MINUTES = ONE_MINUTE * 60L;
    static final Long ONE_DAY_IN_MINUTES = ONE_HOUR_IN_MINUTES * 8L;

    @Test
    public void create_from_duration_in_minutes() {
        Duration duration = Duration.create((long)(ONE_DAY_IN_MINUTES + ONE_HOUR_IN_MINUTES + ONE_MINUTE));
        Assertions.assertThat((long)duration.toMinutes()).isEqualTo(ONE_DAY_IN_MINUTES + ONE_HOUR_IN_MINUTES + ONE_MINUTE);
    }

    @Test
    public void encode() {
        Assertions.assertThat((String)Duration.create((long)(2L * ONE_DAY_IN_MINUTES + 5L * ONE_HOUR_IN_MINUTES + 46L * ONE_MINUTE)).encode(8)).isEqualTo((Object)"2d5h46min");
        Assertions.assertThat((String)Duration.create((long)ONE_DAY_IN_MINUTES).encode(8)).isEqualTo((Object)"1d");
        Assertions.assertThat((String)Duration.create((long)ONE_HOUR_IN_MINUTES).encode(8)).isEqualTo((Object)"1h");
        Assertions.assertThat((String)Duration.create((long)(8L * ONE_HOUR_IN_MINUTES)).encode(8)).isEqualTo((Object)"1d");
        Assertions.assertThat((String)Duration.create((long)ONE_MINUTE).encode(8)).isEqualTo((Object)"1min");
        Assertions.assertThat((String)Duration.create((long)0L).encode(8)).isEqualTo((Object)"0min");
    }

    @Test
    public void decode() {
        Assertions.assertThat((Object)Duration.decode((String)"    15 d  23  h     42min  ", (int)8)).isEqualTo((Object)Duration.create((long)(15L * ONE_DAY_IN_MINUTES + 23L * ONE_HOUR_IN_MINUTES + 42L * ONE_MINUTE)));
        Assertions.assertThat((Object)Duration.decode((String)"15d23h42min", (int)8)).isEqualTo((Object)Duration.create((long)(15L * ONE_DAY_IN_MINUTES + 23L * ONE_HOUR_IN_MINUTES + 42L * ONE_MINUTE)));
        Assertions.assertThat((Object)Duration.decode((String)"23h", (int)8)).isEqualTo((Object)Duration.create((long)(23L * ONE_HOUR_IN_MINUTES)));
        Assertions.assertThat((Object)Duration.decode((String)"15d", (int)8)).isEqualTo((Object)Duration.create((long)(15L * ONE_DAY_IN_MINUTES)));
        Assertions.assertThat((Object)Duration.decode((String)"42min", (int)8)).isEqualTo((Object)Duration.create((long)(42L * ONE_MINUTE)));
        Assertions.assertThat((Object)Duration.decode((String)"0min", (int)8)).isEqualTo((Object)Duration.create((long)0L));
        Assertions.assertThat((Object)Duration.decode((String)"25h61min", (int)8)).isEqualTo((Object)Duration.create((long)(25L * ONE_HOUR_IN_MINUTES + 61L)));
    }

    @Test
    public void fail_to_decode_if_unit_with_invalid_number() {
        try {
            Duration.decode((String)"Xd", (int)8);
            Assert.fail();
        }
        catch (Exception e) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class)).hasMessage("Duration 'Xd' is invalid, it should use the following sample format : 2d 10h 15min");
        }
    }

    @Test
    public void fail_to_decode_if_no_valid_duration() {
        try {
            Duration.decode((String)"foo", (int)8);
            Assert.fail();
        }
        catch (Exception e) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class)).hasMessage("Duration 'foo' is invalid, it should use the following sample format : 2d 10h 15min");
        }
    }

    @Test
    public void fail_to_decode_if_only_number() {
        try {
            Duration.decode((String)"15", (int)8);
            Assert.fail();
        }
        catch (Exception e) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class)).hasMessage("Duration '15' is invalid, it should use the following sample format : 2d 10h 15min");
        }
    }

    @Test
    public void fail_to_decode_if_valid_unit_with_invalid_duration() {
        try {
            Duration.decode((String)"15min foo", (int)8);
            Assert.fail();
        }
        catch (Exception e) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class)).hasMessage("Duration '15min foo' is invalid, it should use the following sample format : 2d 10h 15min");
        }
    }

    @Test
    public void is_greater_than() {
        Assertions.assertThat((boolean)Duration.decode((String)"1h", (int)8).isGreaterThan(Duration.decode((String)"1min", (int)8))).isTrue();
        Assertions.assertThat((boolean)Duration.decode((String)"1min", (int)8).isGreaterThan(Duration.decode((String)"1d", (int)8))).isFalse();
        Assertions.assertThat((boolean)Duration.decode((String)"1d", (int)8).isGreaterThan(Duration.decode((String)"1d", (int)8))).isFalse();
        Assertions.assertThat((boolean)Duration.decode((String)"1d", (int)10).isGreaterThan(Duration.decode((String)"1d", (int)8))).isTrue();
    }

    @Test
    public void add() {
        Assertions.assertThat((Object)Duration.decode((String)"1h", (int)8).add(Duration.decode((String)"1min", (int)8))).isEqualTo((Object)Duration.decode((String)"1h1min", (int)8));
    }

    @Test
    public void subtract() {
        Assertions.assertThat((Object)Duration.decode((String)"1h", (int)8).subtract(Duration.decode((String)"1min", (int)8))).isEqualTo((Object)Duration.decode((String)"59min", (int)8));
    }

    @Test
    public void multiply() {
        Assertions.assertThat((Object)Duration.decode((String)"1h", (int)8).multiply(2)).isEqualTo((Object)Duration.decode((String)"2h", (int)8));
    }

    @Test
    public void test_equals_and_hashcode() throws Exception {
        Duration duration = Duration.create((long)(ONE_DAY_IN_MINUTES + ONE_HOUR_IN_MINUTES + ONE_MINUTE));
        Duration durationWithSameValue = Duration.create((long)(ONE_DAY_IN_MINUTES + ONE_HOUR_IN_MINUTES + ONE_MINUTE));
        Duration durationWithDifferentValue = Duration.create((long)(ONE_DAY_IN_MINUTES + ONE_HOUR_IN_MINUTES));
        Assertions.assertThat((Object)duration).isEqualTo((Object)duration);
        Assertions.assertThat((Object)durationWithSameValue).isEqualTo((Object)duration);
        Assertions.assertThat((Object)durationWithDifferentValue).isNotEqualTo((Object)duration);
        Assertions.assertThat((Object)duration).isNotEqualTo(null);
        Assertions.assertThat((int)duration.hashCode()).isEqualTo(duration.hashCode());
        Assertions.assertThat((int)durationWithSameValue.hashCode()).isEqualTo(duration.hashCode());
        Assertions.assertThat((int)durationWithDifferentValue.hashCode()).isNotEqualTo(duration.hashCode());
    }

    @Test
    public void test_toString() throws Exception {
        Assertions.assertThat((String)Duration.create((long)(ONE_DAY_IN_MINUTES + ONE_HOUR_IN_MINUTES + ONE_MINUTE)).toString()).isNotNull();
    }
}

