/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.ArrayList;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.sonar.api.utils.DateUtils;
import org.sonar.api.utils.SonarException;

@RunWith(value=DataProviderRunner.class)
public class DateUtilsTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void parseDate_valid_format() {
        Date date = DateUtils.parseDate((String)"2010-05-18");
        Assertions.assertThat((int)date.getDate()).isEqualTo(18);
    }

    @Test
    public void parseDate_not_valid_format() {
        this.expectedException.expect(SonarException.class);
        DateUtils.parseDate((String)"2010/05/18");
    }

    @Test
    public void parseDate_not_lenient() {
        this.expectedException.expect(SonarException.class);
        DateUtils.parseDate((String)"2010-13-18");
    }

    @Test
    public void parseDateQuietly() {
        Assertions.assertThat((Date)DateUtils.parseDateQuietly((String)"2010/05/18")).isNull();
        Date date = DateUtils.parseDateQuietly((String)"2010-05-18");
        Assertions.assertThat((int)date.getDate()).isEqualTo(18);
    }

    @Test
    public void parseDate_fail_if_additional_characters() {
        this.expectedException.expect(SonarException.class);
        DateUtils.parseDate((String)"1986-12-04foo");
    }

    @Test
    public void parseDateTime_valid_format() {
        Date date = DateUtils.parseDateTime((String)"2010-05-18T15:50:45+0100");
        Assertions.assertThat((int)date.getMinutes()).isEqualTo(50);
    }

    @Test
    public void parseDateTime_not_valid_format() {
        this.expectedException.expect(SonarException.class);
        DateUtils.parseDate((String)"2010/05/18 10:55");
    }

    @Test
    public void parseDateTime_fail_if_additional_characters() {
        this.expectedException.expect(SonarException.class);
        DateUtils.parseDateTime((String)"1986-12-04T01:02:03+0300foo");
    }

    @Test
    public void parseDateTimeQuietly() {
        Assertions.assertThat((Date)DateUtils.parseDateTimeQuietly((String)"2010/05/18 10:55")).isNull();
        Date date = DateUtils.parseDateTimeQuietly((String)"2010-05-18T15:50:45+0100");
        Assertions.assertThat((int)date.getMinutes()).isEqualTo(50);
    }

    @Test
    public void shouldFormatDate() {
        Assertions.assertThat((String)DateUtils.formatDate((Date)new Date())).startsWith((CharSequence)"20");
        Assertions.assertThat((int)DateUtils.formatDate((Date)new Date()).length()).isEqualTo(10);
    }

    @Test
    public void shouldFormatDateTime() {
        Assertions.assertThat((String)DateUtils.formatDateTime((Date)new Date())).startsWith((CharSequence)"20");
        Assertions.assertThat((int)DateUtils.formatDateTime((Date)new Date()).length()).isGreaterThan(20);
    }

    @Test
    public void shouldFormatDateTime_with_long() {
        Assertions.assertThat((String)DateUtils.formatDateTime((long)System.currentTimeMillis())).startsWith((CharSequence)"20");
        Assertions.assertThat((int)DateUtils.formatDateTime((long)System.currentTimeMillis()).length()).isGreaterThan(20);
    }

    @Test
    public void format_date_time_null_safe() {
        Assertions.assertThat((String)DateUtils.formatDateTimeNullSafe((Date)new Date())).startsWith((CharSequence)"20");
        Assertions.assertThat((int)DateUtils.formatDateTimeNullSafe((Date)new Date()).length()).isGreaterThan(20);
        Assertions.assertThat((String)DateUtils.formatDateTimeNullSafe(null)).isEmpty();
    }

    @Test
    public void long_to_date() {
        Date date = new Date();
        Assertions.assertThat((Date)DateUtils.longToDate((Long)date.getTime())).isEqualTo((Object)date);
        Assertions.assertThat((Date)DateUtils.longToDate(null)).isNull();
    }

    @Test
    public void date_to_long() {
        Date date = new Date();
        Assertions.assertThat((Long)DateUtils.dateToLong((Date)date)).isEqualTo(date.getTime());
        Assertions.assertThat((Long)DateUtils.dateToLong(null)).isEqualTo(null);
    }

    @DataProvider
    public static Object[][] date_times() {
        return new Object[][]{{"2014-05-27", DateUtils.parseDate((String)"2014-05-27")}, {"2014-05-27T15:50:45+0100", DateUtils.parseDateTime((String)"2014-05-27T15:50:45+0100")}, {null, null}};
    }

    @Test
    @UseDataProvider(value="date_times")
    public void param_as__date_time(String stringDate, Date expectedDate) {
        Assertions.assertThat((Date)DateUtils.parseDateOrDateTime((String)stringDate)).isEqualTo((Object)expectedDate);
        Assertions.assertThat((Date)DateUtils.parseStartingDateOrDateTime((String)stringDate)).isEqualTo((Object)expectedDate);
    }

    @DataProvider
    public static Object[][] ending_date_times() {
        return new Object[][]{{"2014-05-27", DateUtils.parseDate((String)"2014-05-28")}, {"2014-05-27T15:50:45+0100", DateUtils.parseDateTime((String)"2014-05-27T15:50:45+0100")}, {null, null}};
    }

    @Test
    @UseDataProvider(value="ending_date_times")
    public void param_as_ending_date_time(String stringDate, Date expectedDate) {
        Assertions.assertThat((Date)DateUtils.parseEndingDateOrDateTime((String)stringDate)).isEqualTo((Object)expectedDate);
    }

    @Test
    public void fail_when_param_as_date_or_datetime_not_a_datetime() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Date 'polop' cannot be parsed as either a date or date+time");
        DateUtils.parseDateOrDateTime((String)"polop");
    }

    @Test
    public void fail_when_param_as_starting_datetime_not_a_datetime() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Date 'polop' cannot be parsed as either a date or date+time");
        DateUtils.parseStartingDateOrDateTime((String)"polop");
    }

    @Test
    public void fail_when_param_as_ending_datetime_not_a_datetime() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("'polop' cannot be parsed as either a date or date+time");
        DateUtils.parseEndingDateOrDateTime((String)"polop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeThreadSafe() throws Exception {
        Thread thread;
        int i;
        final DateUtils.ThreadSafeDateFormat format = new DateUtils.ThreadSafeDateFormat("yyyy-MM-dd'T'HH:mm:ss,S z");
        final Date now = new Date();
        final ArrayList throwables = new ArrayList();
        ThreadGroup tg = new ThreadGroup("shouldBeThreadSafe"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                throwables.add(e);
                super.uncaughtException(t, e);
            }
        };
        final int[] counter = new int[]{0};
        Thread[] threads = new Thread[10];
        for (i = 0; i < threads.length; ++i) {
            threads[i] = new Thread(tg, "JUnit Thread " + i){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int i;
                    Object object;
                    try {
                        object = this;
                        synchronized (object) {
                            this.notifyAll();
                            this.wait();
                        }
                        for (i = 0; i < 1000 && !2.interrupted(); ++i) {
                            String formatted = format.format(now);
                            Thread.yield();
                            Assertions.assertThat((Date)now).isEqualTo((Object)format.parse(formatted));
                        }
                    }
                    catch (Exception e) {
                        Fail.fail((String)("Unexpected exception: " + e));
                    }
                    object = counter;
                    synchronized (counter) {
                        counter[0] = counter[0] + i;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            };
        }
        for (i = 0; i < threads.length; ++i) {
            thread = threads[i];
            synchronized (thread) {
                threads[i].start();
                threads[i].wait();
                continue;
            }
        }
        for (i = 0; i < threads.length; ++i) {
            thread = threads[i];
            synchronized (thread) {
                threads[i].notifyAll();
                continue;
            }
        }
        Thread.sleep(1000L);
        for (i = 0; i < threads.length; ++i) {
            threads[i].interrupt();
        }
        for (i = 0; i < threads.length; ++i) {
            thread = threads[i];
            synchronized (thread) {
                threads[i].join();
                continue;
            }
        }
        Assertions.assertThat(throwables).isEmpty();
        Assertions.assertThat((int)counter[0]).isGreaterThanOrEqualTo(threads.length);
    }
}

