/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.utils.AnnotationUtils;
import org.sonar.api.utils.ChildClass;
import org.sonar.api.utils.FakeAnnotation;
import org.sonar.api.utils.ImplementedClass;
import org.sonar.api.utils.SuperClass;

public class AnnotationUtilsTest {
    @Test
    public void getClassAnnotation() {
        FakeAnnotation annotation = (FakeAnnotation)AnnotationUtils.getAnnotation((Object)new SuperClass(), FakeAnnotation.class);
        Assert.assertThat((Object)annotation.value(), (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    public void getClassAnnotationWithDeprecatedMethod() {
        FakeAnnotation annotation = (FakeAnnotation)AnnotationUtils.getClassAnnotation((Object)new SuperClass(), FakeAnnotation.class);
        Assert.assertThat((Object)annotation.value(), (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    public void searchClassAnnotationInSuperClass() {
        FakeAnnotation annotation = (FakeAnnotation)AnnotationUtils.getAnnotation((Object)new ChildClass(), FakeAnnotation.class);
        Assert.assertThat((Object)annotation.value(), (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    public void searchClassAnnotationInInterface() {
        FakeAnnotation annotation = (FakeAnnotation)AnnotationUtils.getAnnotation((Object)new ImplementedClass(), FakeAnnotation.class);
        Assert.assertThat((Object)annotation.value(), (Matcher)Matchers.is((Object)"foo"));
    }

    @Test
    public void noClassAnnotation() {
        FakeAnnotation annotation = (FakeAnnotation)AnnotationUtils.getAnnotation((Object)"a string", FakeAnnotation.class);
        Assert.assertThat((Object)annotation, (Matcher)IsNull.nullValue());
    }

    @Test
    public void shouldAcceptClasses() {
        FakeAnnotation annotation = (FakeAnnotation)AnnotationUtils.getAnnotation(SuperClass.class, FakeAnnotation.class);
        Assert.assertThat((Object)annotation.value(), (Matcher)Matchers.is((Object)"foo"));
        annotation = (FakeAnnotation)AnnotationUtils.getAnnotation(ChildClass.class, FakeAnnotation.class);
        Assert.assertThat((Object)annotation.value(), (Matcher)Matchers.is((Object)"foo"));
    }
}

