/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.user;

import java.util.ArrayList;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.user.UserQuery;

public class UserQueryTest {
    @Test
    public void test_all_actives() throws Exception {
        Assertions.assertThat((boolean)UserQuery.ALL_ACTIVES.includeDeactivated()).isFalse();
        Assertions.assertThat((Iterable)UserQuery.ALL_ACTIVES.logins()).isNull();
        Assertions.assertThat((String)UserQuery.ALL_ACTIVES.searchText()).isNull();
        Assertions.assertThat((String)UserQuery.ALL_ACTIVES.searchTextSql).isNull();
    }

    @Test
    public void test_all() throws Exception {
        UserQuery all = UserQuery.builder().includeDeactivated().build();
        Assertions.assertThat((boolean)all.includeDeactivated()).isTrue();
        Assertions.assertThat((Iterable)all.logins()).isNull();
    }

    @Test
    public void test_logins() throws Exception {
        UserQuery query = UserQuery.builder().logins(new String[]{"simon", "loic"}).build();
        Assertions.assertThat((boolean)query.includeDeactivated()).isFalse();
        Assertions.assertThat((Iterable)query.logins()).containsOnly((Object[])new String[]{"simon", "loic"});
        query = UserQuery.builder().logins(Arrays.asList("simon", "loic")).build();
        Assertions.assertThat((Iterable)query.logins()).containsOnly((Object[])new String[]{"simon", "loic"});
    }

    @Test
    public void should_limit_number_of_logins() {
        ArrayList<String> logins = new ArrayList<String>();
        for (int i = 0; i < 1010; ++i) {
            logins.add(String.valueOf(i));
        }
        try {
            UserQuery.builder().logins(logins).build();
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Max number of logins is 1000. Got 1010");
        }
    }

    @Test
    public void searchText() {
        UserQuery query = UserQuery.builder().searchText("sim").build();
        Assertions.assertThat((String)query.searchText()).isEqualTo((Object)"sim");
        Assertions.assertThat((String)query.searchTextSql).isEqualTo((Object)"%sim%");
    }

    @Test
    public void searchText_escape_special_characters_in_like() {
        UserQuery query = UserQuery.builder().searchText("%sim_").build();
        Assertions.assertThat((String)query.searchText()).isEqualTo((Object)"%sim_");
        Assertions.assertThat((String)query.searchTextSql).isEqualTo((Object)"%/%sim/_%");
    }
}

