/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.user;

import com.google.common.base.Strings;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.user.UserGroupValidation;

public class UserGroupValidationTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void fail_when_group_name_is_Anyone() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Anyone group cannot be used");
        UserGroupValidation.validateGroupName((String)"AnyOne");
    }

    @Test
    public void fail_when_group_name_is_empty() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Group name cannot be empty");
        UserGroupValidation.validateGroupName((String)"");
    }

    @Test
    public void fail_when_group_name_contains_only_blank() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Group name cannot be empty");
        UserGroupValidation.validateGroupName((String)"     ");
    }

    @Test
    public void fail_when_group_name_is_too_big() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Group name cannot be longer than 255 characters");
        UserGroupValidation.validateGroupName((String)Strings.repeat((String)"name", (int)300));
    }

    @Test
    public void fail_when_group_name_is_null() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Group name cannot be empty");
        UserGroupValidation.validateGroupName(null);
    }
}

