/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.test;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;

public class IsMeasure
extends BaseMatcher<Measure> {
    private Metric metric = null;
    private Double value = null;
    private String data = null;
    private String mismatchTxt;

    public IsMeasure(Metric metric, Double value, String data) {
        this.metric = metric;
        this.value = value;
        this.data = data;
    }

    public IsMeasure(Metric metric) {
        this.metric = metric;
    }

    public IsMeasure(Metric metric, Double value) {
        this.metric = metric;
        this.value = value;
    }

    public IsMeasure(Metric metric, String data) {
        this.metric = metric;
        this.data = data;
    }

    public boolean matches(Object o) {
        Measure m = (Measure)o;
        if (this.metric != null && !ObjectUtils.equals((Object)this.metric, (Object)m.getMetric())) {
            this.mismatchTxt = "metric: " + this.metric.getKey();
            return false;
        }
        if (this.value != null && NumberUtils.compare((double)this.value, (double)m.getValue()) != 0) {
            this.mismatchTxt = "value: " + this.value;
            return false;
        }
        if (this.data != null && !ObjectUtils.equals((Object)this.data, (Object)m.getData())) {
            this.mismatchTxt = "data: " + this.data;
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText(this.mismatchTxt);
    }
}

