/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.task;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.task.Task;
import org.sonar.api.task.TaskDefinition;

public class TaskDefinitionTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void should_build() {
        TaskDefinition def = TaskDefinition.builder().key("foo").taskClass(FooTask.class).description("Foo").build();
        Assertions.assertThat((String)def.key()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)def.description()).isEqualTo((Object)"Foo");
        Assertions.assertThat((Class)def.taskClass()).isEqualTo(FooTask.class);
        Assertions.assertThat((String)def.toString()).isEqualTo((Object)"Task foo[class=org.sonar.api.task.TaskDefinitionTest$FooTask, desc=Foo]");
    }

    @Test
    public void test_equals_and_hashcode() {
        TaskDefinition def1 = TaskDefinition.builder().key("one").taskClass(FooTask.class).description("Foo").build();
        TaskDefinition def1bis = TaskDefinition.builder().key("one").taskClass(FooTask.class).description("Foo").build();
        TaskDefinition def2 = TaskDefinition.builder().key("two").taskClass(FooTask.class).description("Foo").build();
        Assertions.assertThat((Comparable)def1).isEqualTo((Object)def1);
        Assertions.assertThat((Comparable)def1).isEqualTo((Object)def1bis);
        Assertions.assertThat((Comparable)def2).isNotEqualTo((Object)def1);
        Assertions.assertThat((Comparable)def2).isNotEqualTo((Object)"one");
        Assertions.assertThat((Comparable)def2).isNotEqualTo(null);
        Assertions.assertThat((int)def1.hashCode()).isEqualTo(def1.hashCode());
        Assertions.assertThat((int)def1.hashCode()).isEqualTo(def1bis.hashCode());
    }

    @Test
    public void test_compare() {
        TaskDefinition foo = TaskDefinition.builder().key("foo").taskClass(FooTask.class).description("Foo").build();
        TaskDefinition bar = TaskDefinition.builder().key("bar").taskClass(FooTask.class).description("Bar").build();
        Assertions.assertThat((int)foo.compareTo(bar)).isGreaterThan(0);
        Assertions.assertThat((int)foo.compareTo(foo)).isEqualTo(0);
        Assertions.assertThat((int)bar.compareTo(foo)).isLessThan(0);
    }

    @Test
    public void description_should_be_required() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Description must be set for task 'foo'");
        TaskDefinition.builder().key("foo").taskClass(FooTask.class).build();
    }

    @Test
    public void key_should_be_required() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Task key must be set");
        TaskDefinition.builder().description("Foo").taskClass(FooTask.class).build();
    }

    @Test
    public void key_should_not_contain_spaces() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Task key 'fo o' must match [a-zA-Z0-9\\-\\_]+");
        TaskDefinition.builder().key("fo o").description("foo").taskClass(FooTask.class).build();
    }

    @Test
    public void class_should_be_required() {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Class must be set for task 'foo'");
        TaskDefinition.builder().key("foo").description("Foo").build();
    }

    private static class FooTask
    implements Task {
        private FooTask() {
        }

        public void execute() {
        }
    }
}

