/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws.internal;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.internal.SimpleGetRequest;

public class SimpleGetRequestTest {
    SimpleGetRequest underTest = new SimpleGetRequest();

    @Test
    public void method() {
        Assertions.assertThat((String)this.underTest.method()).isEqualTo((Object)"GET");
        this.underTest.setParam("foo", "bar");
        Assertions.assertThat((String)this.underTest.param("foo")).isEqualTo((Object)"bar");
        Assertions.assertThat((String)this.underTest.param("unknown")).isNull();
    }

    @Test
    public void has_param() {
        Assertions.assertThat((String)this.underTest.method()).isEqualTo((Object)"GET");
        this.underTest.setParam("foo", "bar");
        Assertions.assertThat((boolean)this.underTest.hasParam("foo")).isTrue();
        Assertions.assertThat((boolean)this.underTest.hasParam("unknown")).isFalse();
    }

    @Test
    public void get_part() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        this.underTest.setPart("key", inputStream, "filename");
        Request.Part part = this.underTest.paramAsPart("key");
        Assertions.assertThat((InputStream)part.getInputStream()).isEqualTo((Object)inputStream);
        Assertions.assertThat((String)part.getFileName()).isEqualTo((Object)"filename");
        Assertions.assertThat((Object)this.underTest.paramAsPart("unknown")).isNull();
    }

    @Test
    public void getMediaType() {
        this.underTest.setMediaType("JSON");
        Assertions.assertThat((String)this.underTest.getMediaType()).isEqualTo((Object)"JSON");
    }

    @Test
    public void multiParam_with_one_element() {
        this.underTest.setParam("foo", "bar");
        Assertions.assertThat((List)this.underTest.multiParam("foo")).containsExactly((Object[])new String[]{"bar"});
    }

    @Test
    public void multiParam_without_any_element() {
        Assertions.assertThat((List)this.underTest.multiParam("42")).isEmpty();
    }

    @Test
    public void getParams() {
        this.underTest.setParam("foo", "bar").setParam("fee", "beer");
        Assertions.assertThat((Map)this.underTest.getParams()).containsOnly(new Map.Entry[]{Assertions.entry((Object)"foo", (Object)"bar"), Assertions.entry((Object)"fee", (Object)"beer")});
    }
}

