/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.Response;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.utils.log.LogTester;
import org.sonar.api.utils.log.LoggerLevel;

public class WebServiceTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    @Rule
    public LogTester logTester = new LogTester();
    WebService.Context context = new WebService.Context();

    @Test
    public void no_web_services_by_default() {
        Assertions.assertThat((List)this.context.controllers()).isEmpty();
        Assertions.assertThat((Object)this.context.controller("metric")).isNull();
    }

    @Test
    public void define_web_service() {
        MetricWs metricWs = new MetricWs();
        metricWs.define(this.context);
        WebService.Controller controller = this.context.controller("api/metric");
        Assertions.assertThat((Object)controller).isNotNull();
        Assertions.assertThat((String)controller.path()).isEqualTo((Object)"api/metric");
        Assertions.assertThat((String)controller.description()).isEqualTo((Object)"Metrics");
        Assertions.assertThat((String)controller.since()).isEqualTo((Object)"3.2");
        Assertions.assertThat((Iterable)controller.actions()).hasSize(2);
        Assertions.assertThat((boolean)controller.isInternal()).isFalse();
        WebService.Action showAction = controller.action("show");
        Assertions.assertThat((Object)showAction).isNotNull();
        Assertions.assertThat((String)showAction.key()).isEqualTo((Object)"show");
        Assertions.assertThat((String)showAction.description()).isEqualTo((Object)"Show metric");
        Assertions.assertThat((Object)showAction.handler()).isNotNull();
        Assertions.assertThat((URL)showAction.responseExample()).isNotNull();
        Assertions.assertThat((String)showAction.responseExampleFormat()).isNotEmpty();
        Assertions.assertThat((String)showAction.responseExampleAsString()).isNotEmpty();
        Assertions.assertThat((String)showAction.deprecatedSince()).isNull();
        Assertions.assertThat((String)showAction.since()).isEqualTo((Object)"4.2");
        Assertions.assertThat((boolean)showAction.isPost()).isFalse();
        Assertions.assertThat((boolean)showAction.isInternal()).isFalse();
        Assertions.assertThat((String)showAction.path()).isEqualTo((Object)"api/metric/show");
        WebService.Action createAction = controller.action("create");
        Assertions.assertThat((Object)createAction).isNotNull();
        Assertions.assertThat((String)createAction.key()).isEqualTo((Object)"create");
        Assertions.assertThat((String)createAction.toString()).isEqualTo((Object)"api/metric/create");
        Assertions.assertThat((String)createAction.deprecatedSince()).isEqualTo((Object)"5.3");
        Assertions.assertThat((String)createAction.since()).isEqualTo((Object)"4.1");
        Assertions.assertThat((boolean)createAction.isPost()).isTrue();
        Assertions.assertThat((boolean)createAction.isInternal()).isTrue();
    }

    @Test
    public void fail_if_duplicated_ws_keys() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("The web service 'api/metric' is defined multiple times");
        MetricWs metricWs = new MetricWs();
        metricWs.define(this.context);
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/metric");
                WebServiceTest.this.newDefaultAction(newController, "delete");
                newController.done();
            }
        }.define(this.context);
    }

    @Test
    public void fail_if_no_action_handler() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("RequestHandler is not set on action rule/show");
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController controller = context.createController("rule");
                WebServiceTest.this.newDefaultAction(controller, "show").setHandler(null);
                controller.done();
            }
        }.define(this.context);
    }

    @Test
    public void fail_if_duplicated_action_keys() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("The action 'delete' is defined multiple times in the web service 'rule'");
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("rule");
                WebServiceTest.this.newDefaultAction(newController, "create");
                WebServiceTest.this.newDefaultAction(newController, "delete");
                WebServiceTest.this.newDefaultAction(newController, "delete");
                newController.done();
            }
        }.define(this.context);
    }

    @Test
    public void fail_if_no_actions() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("At least one action must be declared in the web service 'rule'");
        new WebService(){

            public void define(WebService.Context context) {
                context.createController("rule").done();
            }
        }.define(this.context);
    }

    @Test
    public void fail_if_no_controller_path() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("WS controller path must not be empty");
        new WebService(){

            public void define(WebService.Context context) {
                context.createController(null).done();
            }
        }.define(this.context);
    }

    @Test
    public void controller_path_must_not_start_with_slash() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("WS controller path must not start or end with slash: /hello");
        new WebService(){

            public void define(WebService.Context context) {
                context.createController("/hello").done();
            }
        }.define(this.context);
    }

    @Test
    public void controller_path_must_not_end_with_slash() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("WS controller path must not start or end with slash: hello/");
        new WebService(){

            public void define(WebService.Context context) {
                context.createController("hello/").done();
            }
        }.define(this.context);
    }

    @Test
    public void handle_request() throws Exception {
        MetricWs metricWs = new MetricWs();
        metricWs.define(this.context);
        Assertions.assertThat((boolean)metricWs.showCalled).isFalse();
        Assertions.assertThat((boolean)metricWs.createCalled).isFalse();
        this.context.controller("api/metric").action("show").handler().handle((Request)Mockito.mock(Request.class), (Response)Mockito.mock(Response.class));
        Assertions.assertThat((boolean)metricWs.showCalled).isTrue();
        Assertions.assertThat((boolean)metricWs.createCalled).isFalse();
        this.context.controller("api/metric").action("create").handler().handle((Request)Mockito.mock(Request.class), (Response)Mockito.mock(Response.class));
        Assertions.assertThat((boolean)metricWs.createCalled).isTrue();
    }

    @Test
    public void action_parameters() {
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/rule");
                WebService.NewAction newAction = WebServiceTest.this.newDefaultAction(newController, "create");
                newAction.createParam("key").setDescription("Key of the new rule");
                newAction.createParam("severity").setDefaultValue((Object)"MAJOR").setSince("4.4").setDeprecatedSince("5.3").setDeprecatedKey("old-severity").setPossibleValues(new Object[]{"INFO", "MAJOR", "BLOCKER"});
                newAction.createParam("internal").setInternal(true);
                newAction.addPagingParams(20);
                newAction.addFieldsParam(Arrays.asList("name", "severity"));
                newAction.addSortParams(Arrays.asList("name", "updatedAt", "severity"), (Object)"updatedAt", false);
                newController.done();
            }
        }.define(this.context);
        WebService.Action action = this.context.controller("api/rule").action("create");
        Assertions.assertThat((Iterable)action.params()).hasSize(8);
        WebService.Param keyParam = action.param("key");
        Assertions.assertThat((String)keyParam.key()).isEqualTo((Object)"key");
        Assertions.assertThat((String)keyParam.description()).isEqualTo((Object)"Key of the new rule");
        Assertions.assertThat((boolean)keyParam.isInternal()).isFalse();
        Assertions.assertThat((String)keyParam.toString()).isEqualTo((Object)"key");
        WebService.Param severityParam = action.param("severity");
        Assertions.assertThat((String)severityParam.key()).isEqualTo((Object)"severity");
        Assertions.assertThat((String)severityParam.description()).isNull();
        Assertions.assertThat((String)severityParam.deprecatedSince()).isEqualTo((Object)"5.3");
        Assertions.assertThat((String)severityParam.since()).isEqualTo((Object)"4.4");
        Assertions.assertThat((String)severityParam.deprecatedKey()).isEqualTo((Object)"old-severity");
        Assertions.assertThat((String)severityParam.defaultValue()).isEqualTo((Object)"MAJOR");
        Assertions.assertThat((Iterable)severityParam.possibleValues()).containsOnly((Object[])new String[]{"INFO", "MAJOR", "BLOCKER"});
        WebService.Param internalParam = action.param("internal");
        Assertions.assertThat((boolean)internalParam.isInternal()).isTrue();
        Assertions.assertThat((String)action.param("p").defaultValue()).isEqualTo((Object)"1");
        Assertions.assertThat((String)action.param("p").description()).isNotEmpty();
        Assertions.assertThat((String)action.param("ps").defaultValue()).isEqualTo((Object)"20");
        Assertions.assertThat((String)action.param("ps").description()).isNotEmpty();
        Assertions.assertThat((Iterable)action.param("f").possibleValues()).containsOnly((Object[])new String[]{"name", "severity"});
        Assertions.assertThat((Iterable)action.param("s").possibleValues()).containsOnly((Object[])new String[]{"name", "severity", "updatedAt"});
        Assertions.assertThat((String)action.param("s").description()).isNotEmpty();
        Assertions.assertThat((String)action.param("asc").defaultValue()).isEqualTo((Object)"false");
    }

    @Test
    public void param_metadata_as_objects() {
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/rule");
                WebService.NewAction create = WebServiceTest.this.newDefaultAction(newController, "create");
                create.createParam("status").setDefaultValue((Object)RuleStatus.BETA).setPossibleValues(new Object[]{RuleStatus.BETA, RuleStatus.READY}).setExampleValue((Object)RuleStatus.BETA);
                create.createParam("max").setDefaultValue((Object)11).setPossibleValues(new Object[]{11, 13, 17}).setExampleValue((Object)17);
                newController.done();
            }
        }.define(this.context);
        WebService.Action action = this.context.controller("api/rule").action("create");
        Assertions.assertThat((String)action.param("status").defaultValue()).isEqualTo((Object)"BETA");
        Assertions.assertThat((Iterable)action.param("status").possibleValues()).containsOnly((Object[])new String[]{"BETA", "READY"});
        Assertions.assertThat((String)action.param("status").exampleValue()).isEqualTo((Object)"BETA");
        Assertions.assertThat((String)action.param("max").defaultValue()).isEqualTo((Object)"11");
        Assertions.assertThat((Iterable)action.param("max").possibleValues()).containsOnly((Object[])new String[]{"11", "13", "17"});
        Assertions.assertThat((String)action.param("max").exampleValue()).isEqualTo((Object)"17");
    }

    @Test
    public void param_null_metadata() {
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/rule");
                WebService.NewAction create = WebServiceTest.this.newDefaultAction(newController, "create");
                create.createParam("status").setDefaultValue(null).setPossibleValues(Collections.emptyList()).setExampleValue(null);
                create.createParam("max").setPossibleValues((Object[])null);
                newController.done();
            }
        }.define(this.context);
        WebService.Action action = this.context.controller("api/rule").action("create");
        Assertions.assertThat((String)action.param("status").defaultValue()).isNull();
        Assertions.assertThat((Iterable)action.param("status").possibleValues()).isNull();
        Assertions.assertThat((String)action.param("status").exampleValue()).isNull();
        Assertions.assertThat((Iterable)action.param("max").possibleValues()).isNull();
    }

    @Test
    public void param_with_empty_possible_values() {
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/rule");
                WebService.NewAction create = WebServiceTest.this.newDefaultAction(newController, "create");
                create.createParam("status").setPossibleValues(Collections.emptyList());
                newController.done();
            }
        }.define(this.context);
        WebService.Action action = this.context.controller("api/rule").action("create");
        Assertions.assertThat((Iterable)action.param("status").possibleValues()).isNull();
    }

    @Test
    public void fail_if_required_param_has_default_value() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Default value must not be set on parameter 'api/rule/create?key' as it's marked as required");
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController controller = context.createController("api/rule");
                WebService.NewAction action = WebServiceTest.this.newDefaultAction(controller, "create");
                action.createParam("key").setRequired(true).setDefaultValue((Object)"abc");
                controller.done();
            }
        }.define(this.context);
    }

    @Test
    public void fail_if_duplicated_action_parameters() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("The parameter 'key' is defined multiple times in the action 'create'");
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController controller = context.createController("api/rule");
                WebService.NewAction action = WebServiceTest.this.newDefaultAction(controller, "create");
                action.createParam("key");
                action.createParam("key");
                controller.done();
            }
        }.define(this.context);
    }

    @Test
    public void ws_is_internal_if_all_actions_are_internal() {
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/rule");
                WebServiceTest.this.newDefaultAction(newController, "create").setInternal(true);
                WebServiceTest.this.newDefaultAction(newController, "update").setInternal(true);
                newController.done();
            }
        }.define(this.context);
        Assertions.assertThat((boolean)this.context.controller("api/rule").isInternal()).isTrue();
    }

    @Test
    public void response_example() {
        MetricWs metricWs = new MetricWs();
        metricWs.define(this.context);
        WebService.Action action = this.context.controller("api/metric").action("create");
        Assertions.assertThat((String)action.responseExampleFormat()).isEqualTo((Object)"txt");
        Assertions.assertThat((URL)action.responseExample()).isNotNull();
        Assertions.assertThat((String)StringUtils.trim((String)action.responseExampleAsString())).isEqualTo((Object)"example of WS response");
    }

    @Test
    public void fail_to_open_response_example() {
        WebService ws = new WebService(){

            public void define(WebService.Context context) {
                try {
                    WebService.NewController controller = context.createController("foo");
                    WebServiceTest.this.newDefaultAction(controller, "bar").setResponseExample(new URL("file:/does/not/exist"));
                    controller.done();
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
        };
        ws.define(this.context);
        WebService.Action action = this.context.controller("foo").action("bar");
        try {
            action.responseExampleAsString();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Fail to load file:/does/not/exist");
        }
    }

    @Test
    public void post_action_without_response_example() {
        WebService ws = new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/rule");
                WebServiceTest.this.newDefaultAction(newController, "list").setPost(true).setResponseExample(null);
                newController.done();
            }
        };
        ws.define(this.context);
        Assertions.assertThat((List)this.logTester.logs(LoggerLevel.WARN)).doesNotContain((Object[])new String[]{"The response example is not set on action api/rule/list"});
    }

    @Test
    public void fail_if_get_and_no_response_example() {
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/rule");
                WebServiceTest.this.newDefaultAction(newController, "list").setResponseExample(null);
                newController.done();
            }
        }.define(this.context);
        Assertions.assertThat((List)this.logTester.logs(LoggerLevel.WARN)).contains((Object[])new String[]{"The response example is not set on action api/rule/list"});
    }

    @Test
    public void log_if_since_on_an_action_is_empty() {
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/rule");
                WebServiceTest.this.newDefaultAction(newController, "list").setSince("");
                newController.done();
            }
        }.define(this.context);
        Assertions.assertThat((List)this.logTester.logs(LoggerLevel.WARN)).contains((Object[])new String[]{"Since is not set on action api/rule/list"});
    }

    @Test
    public void log_if_since_on_an_action_is_null() {
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/rule");
                WebServiceTest.this.newDefaultAction(newController, "list").setSince(null);
                newController.done();
            }
        }.define(this.context);
        Assertions.assertThat((List)this.logTester.logs(LoggerLevel.WARN)).contains((Object[])new String[]{"Since is not set on action api/rule/list"});
    }

    @Test
    public void log_if_action_description_is_empty() {
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/rule");
                WebServiceTest.this.newDefaultAction(newController, "list").setDescription("");
                newController.done();
            }
        }.define(this.context);
        Assertions.assertThat((List)this.logTester.logs(LoggerLevel.WARN)).contains((Object[])new String[]{"Description\u00a0is not set on action api/rule/list"});
    }

    @Test
    public void log_if_action_description_is_null() {
        new WebService(){

            public void define(WebService.Context context) {
                WebService.NewController newController = context.createController("api/rule");
                WebServiceTest.this.newDefaultAction(newController, "list").setDescription(null);
                newController.done();
            }
        }.define(this.context);
        Assertions.assertThat((List)this.logTester.logs(LoggerLevel.WARN)).contains((Object[])new String[]{"Description\u00a0is not set on action api/rule/list"});
    }

    private WebService.NewAction newDefaultAction(WebService.NewController controller, String actionKey) {
        return controller.createAction(actionKey).setDescription("default description").setSince("5.3").setResponseExample(this.getClass().getResource("WebServiceTest/response-example.txt")).setHandler((RequestHandler)Mockito.mock(RequestHandler.class));
    }

    static class MetricWs
    implements WebService {
        boolean showCalled = false;
        boolean createCalled = false;

        MetricWs() {
        }

        public void define(WebService.Context context) {
            WebService.NewController newController = context.createController("api/metric").setDescription("Metrics").setSince("3.2");
            newController.createAction("show").setDescription("Show metric").setSince("4.2").setResponseExample(this.getClass().getResource("WebServiceTest/response-example.txt")).setHandler(new RequestHandler(){

                public void handle(Request request, Response response) {
                    this.show(request, response);
                }
            });
            newController.createAction("create").setDescription("Create metric").setSince("4.1").setDeprecatedSince("5.3").setPost(true).setInternal(true).setResponseExample(this.getClass().getResource("WebServiceTest/response-example.txt")).setHandler(new RequestHandler(){

                public void handle(Request request, Response response) {
                    this.create(request, response);
                }
            });
            newController.done();
        }

        void show(Request request, Response response) {
            this.showCalled = true;
        }

        void create(Request request, Response response) {
            this.createCalled = true;
        }
    }
}

