/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.ws;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.ws.Request;
import org.sonar.api.server.ws.RequestHandler;
import org.sonar.api.server.ws.WebService;
import org.sonar.api.server.ws.internal.PartImpl;
import org.sonar.api.server.ws.internal.ValidatingRequest;
import org.sonar.api.utils.DateUtils;

@RunWith(value=DataProviderRunner.class)
public class RequestTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    FakeRequest underTest = new FakeRequest();

    @Before
    public void before() {
        WebService.Context context = new WebService.Context();
        new FakeWs().define(context);
        this.underTest.setAction(context.controller("my_controller").action("my_action"));
    }

    @Test
    public void has_param() {
        this.underTest.setParam("a_required_string", "foo");
        Assertions.assertThat((boolean)this.underTest.hasParam("a_required_string")).isTrue();
        Assertions.assertThat((boolean)this.underTest.hasParam("unknown")).isFalse();
    }

    @Test
    public void required_param_is_missing() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The 'required_param' parameter is missing");
        this.underTest.mandatoryParam("required_param");
    }

    @Test
    public void required_param() {
        this.underTest.setParam("a_required_string", "foo");
        this.underTest.setParam("a_required_number", "42");
        this.underTest.setParam("a_required_boolean", "true");
        this.underTest.setParam("a_required_enum", "BETA");
        Assertions.assertThat((String)this.underTest.mandatoryParam("a_required_string")).isEqualTo((Object)"foo");
        Assertions.assertThat((boolean)this.underTest.mandatoryParamAsBoolean("a_required_boolean")).isTrue();
        Assertions.assertThat((int)this.underTest.mandatoryParamAsInt("a_required_number")).isEqualTo(42);
        Assertions.assertThat((long)this.underTest.mandatoryParamAsLong("a_required_number")).isEqualTo(42L);
        Assertions.assertThat((Comparable)((Object)this.underTest.mandatoryParamAsEnum("a_required_enum", RuleStatus.class))).isEqualTo((Object)RuleStatus.BETA);
    }

    @Test
    public void required_param_as_strings() {
        this.underTest.setParam("a_required_string", "foo,bar");
        Assertions.assertThat((List)this.underTest.mandatoryParamAsStrings("a_required_string")).containsExactly((Object[])new String[]{"foo", "bar"});
    }

    @Test
    public void fail_if_no_required_param_as_strings() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The 'a_required_string' parameter is missing");
        this.underTest.mandatoryParamAsStrings("a_required_string");
    }

    @Test
    public void mandatory_multi_param() {
        this.underTest.setMultiParam("a_required_multi_param", Lists.newArrayList((Object[])new String[]{"firstValue", "secondValue", "thirdValue"}));
        List result = this.underTest.mandatoryMultiParam("a_required_multi_param");
        Assertions.assertThat((List)result).containsExactly((Object[])new String[]{"firstValue", "secondValue", "thirdValue"});
    }

    @Test
    public void fail_when_no_multi_param() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The 'a_required_multi_param' parameter is missing");
        this.underTest.mandatoryMultiParam("a_required_multi_param");
    }

    @Test
    public void default_value_of_optional_param() {
        Assertions.assertThat((String)this.underTest.param("has_default_string")).isEqualTo((Object)"the_default_string");
    }

    @Test
    public void param_as_string() {
        Assertions.assertThat((String)this.underTest.setParam("a_string", "foo").param("a_string")).isEqualTo((Object)"foo");
        Assertions.assertThat((String)this.underTest.setParam("a_string", " f o o \r\n ").param("a_string")).isEqualTo((Object)"f o o");
    }

    @Test
    public void null_param() {
        Assertions.assertThat((String)this.underTest.param("a_string")).isNull();
        Assertions.assertThat((Boolean)this.underTest.paramAsBoolean("a_boolean")).isNull();
        Assertions.assertThat((Integer)this.underTest.paramAsInt("a_number")).isNull();
        Assertions.assertThat((Long)this.underTest.paramAsLong("a_number")).isNull();
    }

    @Test
    public void param_as_int() {
        Assertions.assertThat((Integer)this.underTest.setParam("a_number", "123").paramAsInt("a_number")).isEqualTo(123);
        Assertions.assertThat((int)this.underTest.setParam("a_number", "123").paramAsInt("a_number", 42)).isEqualTo(123);
        Assertions.assertThat((int)this.underTest.setParam("a_number", null).paramAsInt("a_number", 42)).isEqualTo(123);
    }

    @Test
    public void fail_when_param_is_not_an_int() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The 'a_number' parameter cannot be parsed as an integer value: not-an-int");
        Assertions.assertThat((Integer)this.underTest.setParam("a_number", "not-an-int").paramAsInt("a_number")).isEqualTo(123);
    }

    @Test
    public void fail_when_param_is_not_an_int_with_default_value() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The 'a_number' parameter cannot be parsed as an integer value: not_an_int");
        this.underTest.setParam("a_number", "not_an_int").paramAsInt("a_number", 42);
    }

    @Test
    public void param_as_long() {
        Assertions.assertThat((Long)this.underTest.setParam("a_number", "123").paramAsLong("a_number")).isEqualTo(123L);
        Assertions.assertThat((long)this.underTest.setParam("a_number", "123").paramAsLong("a_number", 42L)).isEqualTo(123L);
        Assertions.assertThat((long)this.underTest.setParam("a_number", null).paramAsLong("a_number", 42L)).isEqualTo(123L);
    }

    @Test
    public void fail_when_param_is_not_a_long() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The 'a_number' parameter cannot be parsed as a long value: not_a_long");
        this.underTest.setParam("a_number", "not_a_long").paramAsLong("a_number");
    }

    @Test
    public void fail_when_param_is_not_a_long_with_default_value() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The 'a_number' parameter cannot be parsed as a long value: not_a_long");
        this.underTest.setParam("a_number", "not_a_long").paramAsLong("a_number", 42L);
    }

    @Test
    public void param_as_boolean() {
        Assertions.assertThat((Boolean)this.underTest.setParam("a_boolean", "true").paramAsBoolean("a_boolean")).isTrue();
        Assertions.assertThat((Boolean)this.underTest.setParam("a_boolean", "yes").paramAsBoolean("a_boolean")).isTrue();
        Assertions.assertThat((Boolean)this.underTest.setParam("a_boolean", "false").paramAsBoolean("a_boolean")).isFalse();
        Assertions.assertThat((Boolean)this.underTest.setParam("a_boolean", "no").paramAsBoolean("a_boolean")).isFalse();
    }

    @Test
    public void fail_if_incorrect_param_as_boolean() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Property a_boolean is not a boolean value: oui");
        this.underTest.setParam("a_boolean", "oui").paramAsBoolean("a_boolean");
    }

    @Test
    public void param_as_enum() {
        Assertions.assertThat((Comparable)((Object)this.underTest.setParam("a_enum", "BETA").paramAsEnum("a_enum", RuleStatus.class))).isEqualTo((Object)RuleStatus.BETA);
    }

    @Test
    public void param_as_enums() {
        Assertions.assertThat((List)this.underTest.setParam("a_enum", "BETA,READY").paramAsEnums("a_enum", RuleStatus.class)).containsOnly((Object[])new RuleStatus[]{RuleStatus.BETA, RuleStatus.READY});
    }

    @Test
    public void param_as_date() {
        Assertions.assertThat((Date)this.underTest.setParam("a_date", "2014-05-27").paramAsDate("a_date")).isEqualTo((Object)DateUtils.parseDate((String)"2014-05-27"));
    }

    @Test
    public void getParam_of_missing_string_parameter() {
        Request.StringParam stringParam = this.underTest.getParam("a_string");
        Assertions.assertThat((boolean)stringParam.isPresent()).isFalse();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)stringParam.or(null);
        });
        Assertions.assertThat((String)((String)stringParam.or(() -> "foo"))).isEqualTo((Object)"foo");
        this.expectGetValueFailureWithISE(() -> ((Request.StringParam)stringParam).getValue());
        Request.StringParam emptyAsNull = stringParam.emptyAsNull();
        Assertions.assertThat((Object)emptyAsNull).isSameAs((Object)stringParam);
        Assertions.assertThat((boolean)emptyAsNull.isPresent()).isFalse();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)emptyAsNull.or(null);
        });
        Assertions.assertThat((String)((String)emptyAsNull.or(() -> "bar"))).isEqualTo((Object)"bar");
        this.expectGetValueFailureWithISE(() -> ((Request.StringParam)emptyAsNull).getValue());
    }

    @Test
    public void getParam_of_existing_string_parameter_with_non_empty_value() {
        this.underTest.setParam("a_string", "sorry");
        Request.StringParam stringParam = this.underTest.getParam("a_string");
        Assertions.assertThat((boolean)stringParam.isPresent()).isTrue();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)stringParam.or(null);
        });
        Assertions.assertThat((String)((String)stringParam.or(() -> "foo"))).isEqualTo((Object)"sorry");
        Assertions.assertThat((String)((String)stringParam.getValue())).isEqualTo((Object)"sorry");
        Request.StringParam emptyAsNull = stringParam.emptyAsNull();
        Assertions.assertThat((Object)emptyAsNull).isSameAs((Object)stringParam);
        Assertions.assertThat((boolean)emptyAsNull.isPresent()).isTrue();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)emptyAsNull.or(null);
        });
        Assertions.assertThat((String)((String)emptyAsNull.or(() -> "bar"))).isEqualTo((Object)"sorry");
        Assertions.assertThat((String)((String)emptyAsNull.getValue())).isEqualTo((Object)"sorry");
    }

    @Test
    public void getParam_of_existing_string_parameter_with_empty_value() {
        this.underTest.setParam("a_string", "");
        Request.StringParam stringParam = this.underTest.getParam("a_string");
        Assertions.assertThat((boolean)stringParam.isPresent()).isTrue();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)stringParam.or(null);
        });
        Assertions.assertThat((String)((String)stringParam.or(() -> "foo"))).isEqualTo((Object)"");
        Assertions.assertThat((String)((String)stringParam.getValue())).isEqualTo((Object)"");
        Request.StringParam emptyAsNull = stringParam.emptyAsNull();
        Assertions.assertThat((Object)emptyAsNull).isNotSameAs((Object)stringParam);
        Assertions.assertThat((boolean)emptyAsNull.isPresent()).isTrue();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)emptyAsNull.or(null);
        });
        Assertions.assertThat((String)((String)emptyAsNull.or(() -> "bar"))).isEqualTo(null);
        Assertions.assertThat((String)((String)emptyAsNull.getValue())).isEqualTo(null);
    }

    @Test
    public void getParam_with_validation_of_missing_string_parameter() {
        Request.StringParam stringParam = this.underTest.getParam("a_string", str -> {
            throw new IllegalStateException("validator should not be called");
        });
        Assertions.assertThat((boolean)stringParam.isPresent()).isFalse();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)stringParam.or(null);
        });
        Assertions.assertThat((String)((String)stringParam.or(() -> "foo"))).isEqualTo((Object)"foo");
        this.expectGetValueFailureWithISE(() -> ((Request.StringParam)stringParam).getValue());
        Request.StringParam emptyAsNull = stringParam.emptyAsNull();
        Assertions.assertThat((Object)emptyAsNull).isSameAs((Object)stringParam);
        Assertions.assertThat((boolean)emptyAsNull.isPresent()).isFalse();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)emptyAsNull.or(null);
        });
        Assertions.assertThat((String)((String)emptyAsNull.or(() -> "bar"))).isEqualTo((Object)"bar");
        this.expectGetValueFailureWithISE(() -> ((Request.StringParam)emptyAsNull).getValue());
    }

    @Test
    public void getParam_with_validation_of_existing_string_parameter_with_non_empty_value() {
        this.underTest.setParam("a_string", "sorry");
        AtomicInteger calls = new AtomicInteger();
        Request.StringParam stringParam = this.underTest.getParam("a_string", str -> calls.incrementAndGet());
        Assertions.assertThat((int)calls.get()).isEqualTo(1);
        Assertions.assertThat((boolean)stringParam.isPresent()).isTrue();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)stringParam.or(null);
        });
        Assertions.assertThat((String)((String)stringParam.or(() -> "foo"))).isEqualTo((Object)"sorry");
        Assertions.assertThat((String)((String)stringParam.getValue())).isEqualTo((Object)"sorry");
        Request.StringParam emptyAsNull = stringParam.emptyAsNull();
        Assertions.assertThat((Object)emptyAsNull).isSameAs((Object)stringParam);
        Assertions.assertThat((boolean)emptyAsNull.isPresent()).isTrue();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)emptyAsNull.or(null);
        });
        Assertions.assertThat((String)((String)emptyAsNull.or(() -> "bar"))).isEqualTo((Object)"sorry");
        Assertions.assertThat((String)((String)emptyAsNull.getValue())).isEqualTo((Object)"sorry");
    }

    @Test
    public void getParam_with_validation_of_existing_string_parameter_with_empty_value() {
        this.underTest.setParam("a_string", "");
        AtomicInteger calls = new AtomicInteger();
        Request.StringParam stringParam = this.underTest.getParam("a_string", str -> calls.incrementAndGet());
        Assertions.assertThat((int)calls.get()).isEqualTo(1);
        Assertions.assertThat((boolean)stringParam.isPresent()).isTrue();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)stringParam.or(null);
        });
        Assertions.assertThat((String)((String)stringParam.or(() -> "foo"))).isEqualTo((Object)"");
        Assertions.assertThat((String)((String)stringParam.getValue())).isEqualTo((Object)"");
        Request.StringParam emptyAsNull = stringParam.emptyAsNull();
        Assertions.assertThat((Object)emptyAsNull).isNotSameAs((Object)stringParam);
        Assertions.assertThat((boolean)emptyAsNull.isPresent()).isTrue();
        this.expectSupplierCanNotBeNullNPE(() -> {
            String cfr_ignored_0 = (String)emptyAsNull.or(null);
        });
        Assertions.assertThat((String)((String)emptyAsNull.or(() -> "bar"))).isEqualTo(null);
        Assertions.assertThat((String)((String)emptyAsNull.getValue())).isEqualTo(null);
    }

    @Test
    public void getParam_with_validation_of_existing_string_parameter_does_not_catch_unchecked_exception_throws_by_validator() {
        this.underTest.setParam("a_string", "boo");
        IllegalArgumentException expected = new IllegalArgumentException("Faking validation of parameter value failed");
        try {
            this.underTest.getParam("a_string", str -> {
                throw expected;
            });
            Assertions.fail((String)"an IllegalStateException should have been raised");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).isSameAs((Object)expected);
        }
    }

    @Test
    public void getParam_of_missing_parameter_of_unspecified_type() {
        Request.Param param = this.underTest.getParam("a_string", (rqt, key) -> {
            throw new IllegalStateException("retrieveAndValidate BiConsumer should not be called");
        });
        Assertions.assertThat((boolean)param.isPresent()).isFalse();
        this.expectSupplierCanNotBeNullNPE(() -> param.or(null));
        Assertions.assertThat((Object)param.or(() -> "foo")).isEqualTo((Object)"foo");
        this.expectGetValueFailureWithISE(() -> ((Request.Param)param).getValue());
    }

    @Test
    public void getParam_of_existing_parameter_of_unspecified_type_with_null_value() {
        this.underTest.setParam("a_string", "value in fake request actually does not matter");
        Request.Param param = this.underTest.getParam("a_string", (rqt, key) -> null);
        Assertions.assertThat((boolean)param.isPresent()).isTrue();
        this.expectSupplierCanNotBeNullNPE(() -> param.or(null));
        Assertions.assertThat((Object)param.or(() -> "foo")).isNull();
        Assertions.assertThat((Object)param.getValue()).isNull();
    }

    @Test
    public void getParam_of_existing_parameter_of_unspecified_type_with_empty_string() {
        this.underTest.setParam("a_string", "value in fake request actually does not matter");
        Request.Param param = this.underTest.getParam("a_string", (rqt, key) -> "");
        Assertions.assertThat((boolean)param.isPresent()).isTrue();
        this.expectSupplierCanNotBeNullNPE(() -> param.or(null));
        Assertions.assertThat((Object)param.or(() -> "foo")).isEqualTo((Object)"");
        Assertions.assertThat((Object)param.getValue()).isEqualTo((Object)"");
    }

    @Test
    public void getParam_of_existing_parameter_of_unspecified_type_with_object() {
        this.underTest.setParam("a_string", "value in fake request actually does not matter");
        Object value = new Object();
        Request.Param param = this.underTest.getParam("a_string", (rqt, key) -> value);
        Assertions.assertThat((boolean)param.isPresent()).isTrue();
        this.expectSupplierCanNotBeNullNPE(() -> param.or(null));
        Assertions.assertThat((Object)param.or(() -> "foo")).isSameAs(value);
        Assertions.assertThat((Object)param.getValue()).isSameAs(value);
    }

    @Test
    public void getParam_of_existing_parameter_of_unspecified_type_does_not_catch_unchecked_exception_thrown_by_BiConsumer() {
        this.underTest.setParam("a_string", "value in fake request actually does not matter");
        RuntimeException expected = new RuntimeException("Faking BiConsumer throwing unchecked exception");
        try {
            this.underTest.getParam("a_string", (rqt, key) -> {
                throw expected;
            });
            Assertions.fail((String)"an RuntimeException should have been raised");
        }
        catch (RuntimeException e) {
            Assertions.assertThat((Throwable)e).isSameAs((Object)expected);
        }
    }

    private void expectGetValueFailureWithISE(Runnable runnable) {
        try {
            runnable.run();
            Assertions.fail((String)"An IllegalStateException should have been raised");
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Param has no value. Use isPresent() before calling getValue()");
        }
    }

    private void expectSupplierCanNotBeNullNPE(Runnable runnable) {
        try {
            runnable.run();
            Assertions.fail((String)"A NullPointerException should have been raised");
        }
        catch (NullPointerException e) {
            Assertions.assertThat((Throwable)e).hasMessage("default value supplier can't be null");
        }
    }

    @DataProvider
    public static Object[][] date_times() {
        return new Object[][]{{"2014-05-27", DateUtils.parseDate((String)"2014-05-27")}, {"2014-05-27T15:50:45+0100", DateUtils.parseDateTime((String)"2014-05-27T15:50:45+0100")}, {null, null}};
    }

    @Test
    @UseDataProvider(value="date_times")
    public void param_as__date_time(String stringDate, Date expectedDate) {
        Assertions.assertThat((Date)this.underTest.setParam("a_date", stringDate).paramAsDateTime("a_date")).isEqualTo((Object)expectedDate);
    }

    @Test
    public void fail_when_param_as_date_not_a_date() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The date 'polop' does not respect format 'yyyy-MM-dd'");
        this.underTest.setParam("a_date", "polop").paramAsDate("a_date");
    }

    @Test
    public void fail_when_param_as_datetime_not_a_datetime() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("'polop' cannot be parsed as either a date or date+time");
        this.underTest.setParam("a_datetime", "polop").paramAsDateTime("a_datetime");
    }

    @Test
    public void param_as_strings() {
        Assertions.assertThat((List)this.underTest.paramAsStrings("a_string")).isNull();
        Assertions.assertThat((List)this.underTest.setParam("a_string", "").paramAsStrings("a_string")).isEmpty();
        Assertions.assertThat((List)this.underTest.setParam("a_string", "bar").paramAsStrings("a_string")).containsExactly((Object[])new String[]{"bar"});
        Assertions.assertThat((List)this.underTest.setParam("a_string", "bar,baz").paramAsStrings("a_string")).containsExactly((Object[])new String[]{"bar", "baz"});
        Assertions.assertThat((List)this.underTest.setParam("a_string", "bar , baz").paramAsStrings("a_string")).containsExactly((Object[])new String[]{"bar", "baz"});
    }

    @Test
    public void deprecated_key() {
        Assertions.assertThat((String)this.underTest.setParam("deprecated_param", "bar").param("new_param")).isEqualTo((Object)"bar");
    }

    @Test
    public void fail_if_param_is_not_defined() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("BUG - parameter 'unknown' is undefined for action 'my_action'");
        this.underTest.param("unknown");
    }

    @Test
    public void fail_if_multi_param_is_not_defined() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("BUG - parameter 'unknown' is undefined for action 'my_action'");
        this.underTest.multiParam("unknown");
    }

    @Test
    public void verify_possible_values() {
        this.underTest.setParam("has_possible_values", "foo");
        Assertions.assertThat((String)this.underTest.param("has_possible_values")).isEqualTo((Object)"foo");
    }

    @Test
    public void fail_if_not_a_possible_value() {
        this.underTest.setParam("has_possible_values", "not_possible");
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Value of parameter 'has_possible_values' (not_possible) must be one of: [foo, bar]");
        this.underTest.param("has_possible_values");
    }

    @Test
    public void param_as_input_stream() throws Exception {
        Assertions.assertThat((InputStream)this.underTest.paramAsInputStream("a_string")).isNull();
        Assertions.assertThat((String)IOUtils.toString((InputStream)this.underTest.setParam("a_string", "").paramAsInputStream("a_string"))).isEmpty();
        Assertions.assertThat((String)IOUtils.toString((InputStream)this.underTest.setParam("a_string", "foo").paramAsInputStream("a_string"))).isEqualTo((Object)"foo");
    }

    @Test
    public void param_as_part() throws Exception {
        InputStream inputStream = (InputStream)Mockito.mock(InputStream.class);
        this.underTest.setPart("key", inputStream, "filename");
        Request.Part part = this.underTest.paramAsPart("key");
        Assertions.assertThat((InputStream)part.getInputStream()).isEqualTo((Object)inputStream);
        Assertions.assertThat((String)part.getFileName()).isEqualTo((Object)"filename");
        Assertions.assertThat((Object)this.underTest.paramAsPart("unknown")).isNull();
    }

    @Test
    public void mandatory_param_as_part() throws Exception {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("The 'required_param' parameter is missing");
        this.underTest.mandatoryParamAsPart("required_param");
    }

    private static class FakeWs
    implements WebService {
        private FakeWs() {
        }

        public void define(WebService.Context context) {
            WebService.NewController controller = context.createController("my_controller");
            WebService.NewAction action = controller.createAction("my_action").setDescription("Action Description").setPost(true).setSince("5.2").setHandler((RequestHandler)Mockito.mock(RequestHandler.class));
            action.createParam("required_param").setRequired(true);
            action.createParam("a_string");
            action.createParam("a_boolean");
            action.createParam("a_number");
            action.createParam("a_enum");
            action.createParam("a_date");
            action.createParam("a_datetime");
            action.createParam("a_required_string").setRequired(true);
            action.createParam("a_required_boolean").setRequired(true);
            action.createParam("a_required_number").setRequired(true);
            action.createParam("a_required_enum").setRequired(true);
            action.createParam("a_required_multi_param").setRequired(true);
            action.createParam("has_default_string").setDefaultValue((Object)"the_default_string");
            action.createParam("has_default_number").setDefaultValue((Object)"10");
            action.createParam("has_default_boolean").setDefaultValue((Object)"true");
            action.createParam("has_possible_values").setPossibleValues(new Object[]{"foo", "bar"});
            action.createParam("new_param").setDeprecatedKey("deprecated_param");
            action.createParam("new_param_with_default_value").setDeprecatedKey("deprecated_new_param_with_default_value").setDefaultValue((Object)"the_default_string");
            controller.done();
        }
    }

    private static class FakeRequest
    extends ValidatingRequest {
        private final ListMultimap<String, String> multiParams = ArrayListMultimap.create();
        private final Map<String, String> params = new HashMap<String, String>();
        private final Map<String, Request.Part> parts = new HashMap<String, Request.Part>();

        private FakeRequest() {
        }

        public String method() {
            return "GET";
        }

        public String getMediaType() {
            return "application/json";
        }

        public boolean hasParam(String key) {
            return this.params.keySet().contains(key);
        }

        public String getPath() {
            return null;
        }

        public FakeRequest setParam(String key, @Nullable String value) {
            if (value != null) {
                this.params.put(key, value);
            }
            return this;
        }

        public FakeRequest setMultiParam(String key, List<String> values) {
            this.multiParams.putAll((Object)key, values);
            return this;
        }

        protected String readParam(String key) {
            return this.params.get(key);
        }

        protected List<String> readMultiParam(String key) {
            return this.multiParams.get((Object)key);
        }

        protected InputStream readInputStreamParam(String key) {
            String param = this.readParam(key);
            return param == null ? null : IOUtils.toInputStream((String)param);
        }

        protected Request.Part readPart(String key) {
            return this.parts.get(key);
        }

        public FakeRequest setPart(String key, InputStream input, String fileName) {
            this.parts.put(key, (Request.Part)new PartImpl(input, fileName));
            return this;
        }
    }
}

