/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.assertj.core.api.Assertions;
import org.hamcrest.Matcher;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionXmlLoader;
import org.sonar.test.ExceptionCauseMatcher;

public class RulesDefinitionXmlLoaderTest {
    @Rule
    public final ExpectedException expectedException = ExpectedException.none();
    RulesDefinitionXmlLoader underTest = new RulesDefinitionXmlLoader();

    @Test
    public void parse_xml() {
        InputStream input = this.getClass().getResourceAsStream("RulesDefinitionXmlLoaderTest/rules.xml");
        RulesDefinition.Repository repository = this.load(input, StandardCharsets.UTF_8.name());
        Assertions.assertThat((List)repository.rules()).hasSize(2);
        RulesDefinition.Rule rule = repository.rule("complete");
        Assertions.assertThat((String)rule.key()).isEqualTo((Object)"complete");
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"Complete");
        Assertions.assertThat((String)rule.htmlDescription()).isEqualTo((Object)"Description of Complete");
        Assertions.assertThat((String)rule.severity()).isEqualTo((Object)"BLOCKER");
        Assertions.assertThat((boolean)rule.template()).isTrue();
        Assertions.assertThat((Comparable)rule.status()).isEqualTo((Object)RuleStatus.BETA);
        Assertions.assertThat((String)rule.internalKey()).isEqualTo((Object)"Checker/TreeWalker/LocalVariableName");
        Assertions.assertThat((Comparable)rule.type()).isEqualTo((Object)RuleType.BUG);
        Assertions.assertThat((Iterable)rule.tags()).containsOnly((Object[])new String[]{"misra", "spring"});
        Assertions.assertThat((List)rule.params()).hasSize(2);
        RulesDefinition.Param ignore = rule.param("ignore");
        Assertions.assertThat((String)ignore.key()).isEqualTo((Object)"ignore");
        Assertions.assertThat((String)ignore.description()).isEqualTo((Object)"Ignore ?");
        Assertions.assertThat((String)ignore.defaultValue()).isEqualTo((Object)"false");
        rule = repository.rule("minimal");
        Assertions.assertThat((String)rule.key()).isEqualTo((Object)"minimal");
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"Minimal");
        Assertions.assertThat((String)rule.htmlDescription()).isEqualTo((Object)"Description of Minimal");
        Assertions.assertThat((List)rule.params()).isEmpty();
        Assertions.assertThat((Comparable)rule.status()).isEqualTo((Object)RuleStatus.READY);
        Assertions.assertThat((String)rule.severity()).isEqualTo((Object)"MAJOR");
        Assertions.assertThat((Comparable)rule.type()).isEqualTo((Object)RuleType.CODE_SMELL);
    }

    @Test
    public void fail_if_missing_rule_key() {
        this.expectedException.expect(IllegalStateException.class);
        this.load(IOUtils.toInputStream((String)"<rules><rule><name>Foo</name></rule></rules>"), StandardCharsets.UTF_8.name());
    }

    @Test
    public void fail_if_missing_property_key() {
        this.expectedException.expect(IllegalStateException.class);
        this.load(IOUtils.toInputStream((String)"<rules><rule><key>foo</key><name>Foo</name><param></param></rule></rules>"), StandardCharsets.UTF_8.name());
    }

    @Test
    public void fail_on_invalid_rule_parameter_type() {
        this.expectedException.expect(IllegalStateException.class);
        this.load(IOUtils.toInputStream((String)"<rules><rule><key>foo</key><name>Foo</name><param><key>key</key><type>INVALID</type></param></rule></rules>"), StandardCharsets.UTF_8.name());
    }

    @Test
    public void fail_if_invalid_xml() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("XML is not valid");
        InputStream input = this.getClass().getResourceAsStream("RulesDefinitionXmlLoaderTest/invalid.xml");
        this.load(input, StandardCharsets.UTF_8.name());
    }

    @Test
    public void test_utf8_encoding() throws UnsupportedEncodingException {
        InputStream input = this.getClass().getResourceAsStream("RulesDefinitionXmlLoaderTest/utf8.xml");
        RulesDefinition.Repository repository = this.load(input, StandardCharsets.UTF_8.name());
        Assertions.assertThat((List)repository.rules()).hasSize(1);
        RulesDefinition.Rule rule = (RulesDefinition.Rule)repository.rules().get(0);
        Assertions.assertThat((String)rule.key()).isEqualTo((Object)"com.puppycrawl.tools.checkstyle.checks.naming.LocalVariableNameCheck");
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"M & M");
        Assertions.assertThat((char)rule.htmlDescription().charAt(0)).isEqualTo('\u00e9');
        Assertions.assertThat((char)rule.htmlDescription().charAt(1)).isEqualTo('\u00e0');
        Assertions.assertThat((char)rule.htmlDescription().charAt(2)).isEqualTo('&');
    }

    @Test
    public void support_deprecated_format() {
        InputStream input = this.getClass().getResourceAsStream("RulesDefinitionXmlLoaderTest/deprecated.xml");
        RulesDefinition.Repository repository = this.load(input, StandardCharsets.UTF_8.name());
        Assertions.assertThat((List)repository.rules()).hasSize(1);
        RulesDefinition.Rule rule = (RulesDefinition.Rule)repository.rules().get(0);
        Assertions.assertThat((String)rule.key()).isEqualTo((Object)"org.sonar.it.checkstyle.MethodsCountCheck");
        Assertions.assertThat((String)rule.internalKey()).isEqualTo((Object)"Checker/TreeWalker/org.sonar.it.checkstyle.MethodsCountCheck");
        Assertions.assertThat((String)rule.severity()).isEqualTo((Object)"CRITICAL");
        Assertions.assertThat((String)rule.htmlDescription()).isEqualTo((Object)"Count methods");
        Assertions.assertThat((Object)rule.param("minMethodsCount")).isNotNull();
    }

    @Test
    public void test_linear_remediation_function() throws Exception {
        String xml = "<rules>  <rule>    <key>1</key>    <name>One</name>    <description>Desc</description>    <gapDescription>lines</gapDescription>    <remediationFunction>LINEAR</remediationFunction>    <remediationFunctionGapMultiplier>2d 3h</remediationFunctionGapMultiplier>  </rule></rules>";
        RulesDefinition.Rule rule = this.load(xml).rule("1");
        Assertions.assertThat((String)rule.gapDescription()).isEqualTo((Object)"lines");
        DebtRemediationFunction function = rule.debtRemediationFunction();
        Assertions.assertThat((Object)function).isNotNull();
        Assertions.assertThat((Comparable)function.type()).isEqualTo((Object)DebtRemediationFunction.Type.LINEAR);
        Assertions.assertThat((String)function.gapMultiplier()).isEqualTo((Object)"2d3h");
        Assertions.assertThat((String)function.baseEffort()).isNull();
    }

    @Test
    public void test_linear_with_offset_remediation_function() {
        String xml = "<rules>  <rule>    <key>1</key>    <name>One</name>    <description>Desc</description>    <effortToFixDescription>lines</effortToFixDescription>    <remediationFunction>LINEAR_OFFSET</remediationFunction>    <remediationFunctionGapMultiplier>2d 3h</remediationFunctionGapMultiplier>    <remediationFunctionBaseEffort>5min</remediationFunctionBaseEffort>  </rule></rules>";
        RulesDefinition.Rule rule = this.load(xml).rule("1");
        Assertions.assertThat((String)rule.gapDescription()).isEqualTo((Object)"lines");
        DebtRemediationFunction function = rule.debtRemediationFunction();
        Assertions.assertThat((Object)function).isNotNull();
        Assertions.assertThat((Comparable)function.type()).isEqualTo((Object)DebtRemediationFunction.Type.LINEAR_OFFSET);
        Assertions.assertThat((String)function.gapMultiplier()).isEqualTo((Object)"2d3h");
        Assertions.assertThat((String)function.baseEffort()).isEqualTo((Object)"5min");
    }

    @Test
    public void test_constant_remediation_function() {
        String xml = "<rules>  <rule>    <key>1</key>    <name>One</name>    <description>Desc</description>    <remediationFunction>CONSTANT_ISSUE</remediationFunction>    <remediationFunctionBaseEffort>5min</remediationFunctionBaseEffort>  </rule></rules>";
        RulesDefinition.Rule rule = this.load(xml).rule("1");
        DebtRemediationFunction function = rule.debtRemediationFunction();
        Assertions.assertThat((Object)function).isNotNull();
        Assertions.assertThat((Comparable)function.type()).isEqualTo((Object)DebtRemediationFunction.Type.CONSTANT_ISSUE);
        Assertions.assertThat((String)function.gapMultiplier()).isNull();
        Assertions.assertThat((String)function.baseEffort()).isEqualTo((Object)"5min");
    }

    @Test
    public void fail_if_invalid_remediation_function() {
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Fail to load the rule with key [squid:1]");
        this.expectedException.expectCause((Matcher)ExceptionCauseMatcher.hasType(IllegalArgumentException.class).andMessage("No enum constant org.sonar.api.server.debt.DebtRemediationFunction.Type.UNKNOWN"));
        this.load("<rules>  <rule>    <key>1</key>    <name>One</name>    <description>Desc</description>    <remediationFunction>UNKNOWN</remediationFunction>  </rule></rules>");
    }

    @Test
    public void ignore_deprecated_sqale_characteristic() {
        String xml = "<rules>  <rule>    <key>1</key>    <name>One</name>    <description>Desc</description>    <effortToFixDescription>lines</effortToFixDescription>    <debtSubCharacteristic>BUG</debtSubCharacteristic>    <remediationFunction>LINEAR_OFFSET</remediationFunction>    <remediationFunctionGapMultiplier>2d 3h</remediationFunctionGapMultiplier>    <remediationFunctionBaseEffort>5min</remediationFunctionBaseEffort>  </rule></rules>";
        RulesDefinition.Rule rule = this.load(xml).rule("1");
        Assertions.assertThat((String)rule.debtSubCharacteristic()).isNull();
    }

    @Test
    public void markdown_description() {
        String xml = "<rules>  <rule>    <key>1</key>    <name>One</name>    <description>Desc</description>    <descriptionFormat>MARKDOWN</descriptionFormat>  </rule></rules>";
        RulesDefinition.Rule rule = this.load(xml).rule("1");
        Assertions.assertThat((String)rule.markdownDescription()).isEqualTo((Object)"Desc");
        Assertions.assertThat((String)rule.htmlDescription()).isNull();
    }

    @Test
    public void fail_if_unsupported_description_format() {
        String xml = "<rules>  <rule>    <key>1</key>    <name>One</name>    <description>Desc</description>    <descriptionFormat>UNKNOWN</descriptionFormat>  </rule></rules>";
        this.expectedException.expect(IllegalStateException.class);
        this.expectedException.expectMessage("Fail to load the rule with key [squid:1]");
        this.expectedException.expectCause((Matcher)ExceptionCauseMatcher.hasType(IllegalArgumentException.class).andMessage("No enum constant org.sonar.api.server.rule.RulesDefinitionXmlLoader.DescriptionFormat.UNKNOWN"));
        this.load(xml).rule("1");
    }

    @Test
    public void test_deprecated_remediation_function() {
        String xml = "<rules>  <rule>    <key>1</key>    <name>One</name>    <description>Desc</description>    <effortToFixDescription>lines</effortToFixDescription>    <debtRemediationFunction>LINEAR_OFFSET</debtRemediationFunction>    <debtRemediationFunctionCoefficient>2d 3h</debtRemediationFunctionCoefficient>    <debtRemediationFunctionOffset>5min</debtRemediationFunctionOffset>  </rule></rules>";
        RulesDefinition.Rule rule = this.load(xml).rule("1");
        Assertions.assertThat((String)rule.gapDescription()).isEqualTo((Object)"lines");
        DebtRemediationFunction function = rule.debtRemediationFunction();
        Assertions.assertThat((Object)function).isNotNull();
        Assertions.assertThat((Comparable)function.type()).isEqualTo((Object)DebtRemediationFunction.Type.LINEAR_OFFSET);
        Assertions.assertThat((String)function.gapMultiplier()).isEqualTo((Object)"2d3h");
        Assertions.assertThat((String)function.baseEffort()).isEqualTo((Object)"5min");
    }

    private RulesDefinition.Repository load(InputStream input, String encoding) {
        RulesDefinition.Context context = new RulesDefinition.Context();
        RulesDefinition.NewRepository newRepository = context.createRepository("squid", "java");
        this.underTest.load(newRepository, input, encoding);
        newRepository.done();
        return context.repository("squid");
    }

    private RulesDefinition.Repository load(String xml) {
        RulesDefinition.Context context = new RulesDefinition.Context();
        RulesDefinition.NewRepository newRepository = context.createRepository("squid", "java");
        this.underTest.load(newRepository, (Reader)new StringReader(xml));
        newRepository.done();
        return context.repository("squid");
    }
}

