/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.net.URL;
import java.util.List;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.log.LogTester;

public class RulesDefinitionTest {
    RulesDefinition.Context context = new RulesDefinition.Context();
    @Rule
    public LogTester logTester = new LogTester();
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void define_repositories() {
        Assertions.assertThat((List)this.context.repositories()).isEmpty();
        this.context.createRepository("findbugs", "java").setName("Findbugs").done();
        this.context.createRepository("checkstyle", "java").done();
        Assertions.assertThat((List)this.context.repositories()).hasSize(2);
        RulesDefinition.Repository findbugs = this.context.repository("findbugs");
        Assertions.assertThat((Object)findbugs).isNotNull();
        Assertions.assertThat((String)findbugs.key()).isEqualTo((Object)"findbugs");
        Assertions.assertThat((String)findbugs.language()).isEqualTo((Object)"java");
        Assertions.assertThat((String)findbugs.name()).isEqualTo((Object)"Findbugs");
        Assertions.assertThat((List)findbugs.rules()).isEmpty();
        RulesDefinition.Repository checkstyle = this.context.repository("checkstyle");
        Assertions.assertThat((Object)checkstyle).isNotNull();
        Assertions.assertThat((String)checkstyle.key()).isEqualTo((Object)"checkstyle");
        Assertions.assertThat((String)checkstyle.language()).isEqualTo((Object)"java");
        Assertions.assertThat((String)checkstyle.name()).isEqualTo((Object)"checkstyle");
        Assertions.assertThat((List)checkstyle.rules()).isEmpty();
        Assertions.assertThat((Object)this.context.repository("unknown")).isNull();
        ((AbstractObjectAssert)((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)findbugs).isEqualTo((Object)findbugs)).isNotEqualTo((Object)checkstyle)).isNotEqualTo((Object)"findbugs")).isNotEqualTo(null);
        Assertions.assertThat((int)findbugs.hashCode()).isEqualTo(findbugs.hashCode());
    }

    @Test
    public void define_rules() {
        RulesDefinition.NewRepository newRepo = this.context.createRepository("findbugs", "java");
        newRepo.createRule("NPE").setName("Detect NPE").setHtmlDescription("Detect <code>java.lang.NullPointerException</code>").setSeverity("BLOCKER").setInternalKey("/something").setStatus(RuleStatus.BETA).setTags(new String[]{"one", "two"}).addTags(new String[]{"two", "three", "four"});
        newRepo.createRule("ABC").setName("ABC").setMarkdownDescription("ABC");
        newRepo.done();
        RulesDefinition.Repository repo = this.context.repository("findbugs");
        Assertions.assertThat((List)repo.rules()).hasSize(2);
        RulesDefinition.Rule rule = repo.rule("NPE");
        Assertions.assertThat((String)rule.key()).isEqualTo((Object)"NPE");
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"Detect NPE");
        Assertions.assertThat((String)rule.severity()).isEqualTo((Object)"BLOCKER");
        Assertions.assertThat((String)rule.htmlDescription()).isEqualTo((Object)"Detect <code>java.lang.NullPointerException</code>");
        Assertions.assertThat((String)rule.markdownDescription()).isNull();
        Assertions.assertThat((Iterable)rule.tags()).containsOnly((Object[])new String[]{"one", "two", "three", "four"});
        Assertions.assertThat((List)rule.params()).isEmpty();
        Assertions.assertThat((String)rule.internalKey()).isEqualTo((Object)"/something");
        Assertions.assertThat((boolean)rule.template()).isFalse();
        Assertions.assertThat((Comparable)rule.status()).isEqualTo((Object)RuleStatus.BETA);
        Assertions.assertThat((String)rule.toString()).isEqualTo((Object)"[repository=findbugs, key=NPE]");
        Assertions.assertThat((Object)rule.repository()).isSameAs((Object)repo);
        RulesDefinition.Rule otherRule = repo.rule("ABC");
        Assertions.assertThat((String)otherRule.htmlDescription()).isNull();
        Assertions.assertThat((String)otherRule.markdownDescription()).isEqualTo((Object)"ABC");
        ((AbstractObjectAssert)((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)rule).isEqualTo((Object)rule)).isNotEqualTo((Object)otherRule)).isNotEqualTo((Object)"NPE")).isNotEqualTo(null);
        Assertions.assertThat((int)rule.hashCode()).isEqualTo(rule.hashCode());
    }

    @Test
    public void define_rules_with_remediation_function() {
        RulesDefinition.NewRepository newRepo = this.context.createRepository("common-java", "java");
        RulesDefinition.NewRule newRule = newRepo.createRule("InsufficientBranchCoverage").setName("Insufficient condition coverage").setHtmlDescription("Insufficient condition coverage by unit tests").setSeverity("MAJOR").setGapDescription("Effort to test one uncovered branch");
        newRule.setDebtRemediationFunction(newRule.debtRemediationFunctions().linearWithOffset("1h", "10min"));
        newRepo.done();
        RulesDefinition.Repository repo = this.context.repository("common-java");
        Assertions.assertThat((List)repo.rules()).hasSize(1);
        RulesDefinition.Rule rule = repo.rule("InsufficientBranchCoverage");
        Assertions.assertThat((Comparable)rule.debtRemediationFunction().type()).isEqualTo((Object)DebtRemediationFunction.Type.LINEAR_OFFSET);
        Assertions.assertThat((String)rule.debtRemediationFunction().gapMultiplier()).isEqualTo((Object)"1h");
        Assertions.assertThat((String)rule.debtRemediationFunction().baseEffort()).isEqualTo((Object)"10min");
        Assertions.assertThat((String)rule.gapDescription()).isEqualTo((Object)"Effort to test one uncovered branch");
    }

    @Test
    public void define_rule_with_default_fields() {
        RulesDefinition.NewRepository newFindbugs = this.context.createRepository("findbugs", "java");
        newFindbugs.createRule("NPE").setName("NPE").setHtmlDescription("NPE");
        newFindbugs.done();
        RulesDefinition.Rule rule = this.context.repository("findbugs").rule("NPE");
        Assertions.assertThat((String)rule.key()).isEqualTo((Object)"NPE");
        Assertions.assertThat((String)rule.severity()).isEqualTo((Object)"MAJOR");
        Assertions.assertThat((List)rule.params()).isEmpty();
        Assertions.assertThat((String)rule.internalKey()).isNull();
        Assertions.assertThat((Comparable)rule.status()).isEqualTo((Object)RuleStatus.defaultStatus());
        Assertions.assertThat((Iterable)rule.tags()).isEmpty();
        Assertions.assertThat((Object)rule.debtRemediationFunction()).isNull();
    }

    @Test
    public void define_rule_parameters() {
        RulesDefinition.NewRepository newFindbugs = this.context.createRepository("findbugs", "java");
        RulesDefinition.NewRule newNpe = newFindbugs.createRule("NPE").setName("NPE").setHtmlDescription("NPE");
        newNpe.createParam("level").setDefaultValue("LOW").setName("Level").setDescription("The level").setType(RuleParamType.INTEGER);
        newNpe.createParam("effort");
        newFindbugs.done();
        RulesDefinition.Rule rule = this.context.repository("findbugs").rule("NPE");
        Assertions.assertThat((List)rule.params()).hasSize(2);
        RulesDefinition.Param level = rule.param("level");
        Assertions.assertThat((String)level.key()).isEqualTo((Object)"level");
        Assertions.assertThat((String)level.name()).isEqualTo((Object)"Level");
        Assertions.assertThat((String)level.description()).isEqualTo((Object)"The level");
        Assertions.assertThat((String)level.defaultValue()).isEqualTo((Object)"LOW");
        Assertions.assertThat((Object)level.type()).isEqualTo((Object)RuleParamType.INTEGER);
        RulesDefinition.Param effort = rule.param("effort");
        ((AbstractCharSequenceAssert)Assertions.assertThat((String)effort.key()).isEqualTo((Object)"effort")).isEqualTo((Object)effort.name());
        Assertions.assertThat((String)effort.description()).isNull();
        Assertions.assertThat((String)effort.defaultValue()).isNull();
        Assertions.assertThat((Object)effort.type()).isEqualTo((Object)RuleParamType.STRING);
        ((AbstractObjectAssert)((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)level).isEqualTo((Object)level)).isNotEqualTo((Object)effort)).isNotEqualTo((Object)"level")).isNotEqualTo(null);
        Assertions.assertThat((int)level.hashCode()).isEqualTo(level.hashCode());
    }

    @Test
    public void define_rule_parameter_with_empty_default_value() {
        RulesDefinition.NewRepository newFindbugs = this.context.createRepository("findbugs", "java");
        RulesDefinition.NewRule newNpe = newFindbugs.createRule("NPE").setName("NPE").setHtmlDescription("NPE");
        newNpe.createParam("level").setDefaultValue("").setName("Level").setDescription("The level").setType(RuleParamType.INTEGER);
        newFindbugs.done();
        RulesDefinition.Rule rule = this.context.repository("findbugs").rule("NPE");
        Assertions.assertThat((List)rule.params()).hasSize(1);
        RulesDefinition.Param level = rule.param("level");
        Assertions.assertThat((String)level.key()).isEqualTo((Object)"level");
        Assertions.assertThat((String)level.name()).isEqualTo((Object)"Level");
        Assertions.assertThat((String)level.description()).isEqualTo((Object)"The level");
        Assertions.assertThat((String)level.defaultValue()).isNull();
        Assertions.assertThat((Object)level.type()).isEqualTo((Object)RuleParamType.INTEGER);
    }

    @Test
    public void sanitize_rule_name() {
        RulesDefinition.NewRepository newFindbugs = this.context.createRepository("findbugs", "java");
        newFindbugs.createRule("NPE").setName("   \n  NullPointer   \n   ").setHtmlDescription("NPE");
        newFindbugs.done();
        RulesDefinition.Rule rule = this.context.repository("findbugs").rule("NPE");
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"NullPointer");
    }

    @Test
    public void add_rules_to_existing_repository() {
        RulesDefinition.NewRepository newFindbugs = this.context.createRepository("findbugs", "java").setName("Findbugs");
        newFindbugs.createRule("NPE").setName("NPE").setHtmlDescription("NPE");
        newFindbugs.done();
        RulesDefinition.NewRepository newFbContrib = this.context.createRepository("findbugs", "java");
        newFbContrib.createRule("VULNERABILITY").setName("Vulnerability").setMarkdownDescription("Detect vulnerability");
        newFbContrib.done();
        Assertions.assertThat((List)this.context.repositories()).hasSize(1);
        RulesDefinition.Repository findbugs = this.context.repository("findbugs");
        Assertions.assertThat((String)findbugs.key()).isEqualTo((Object)"findbugs");
        Assertions.assertThat((String)findbugs.language()).isEqualTo((Object)"java");
        Assertions.assertThat((String)findbugs.name()).isEqualTo((Object)"Findbugs");
        Assertions.assertThat((List)findbugs.rules()).extracting("key").containsOnly(new Object[]{"NPE", "VULNERABILITY"});
    }

    @Test
    public void allow_to_replace_an_existing_common_rule() {
        RulesDefinition.NewRepository newCommonJava1 = this.context.createRepository("common-java", "java").setName("Common Java");
        newCommonJava1.createRule("coverage").setName("Lack of coverage").setHtmlDescription("Coverage must be high");
        newCommonJava1.done();
        RulesDefinition.NewRepository newCommonJava2 = this.context.createRepository("common-java", "java");
        newCommonJava2.createRule("coverage").setName("Lack of coverage (V2)").setMarkdownDescription("Coverage must be high (V2)");
        newCommonJava2.done();
        RulesDefinition.Repository commonJava = this.context.repository("common-java");
        Assertions.assertThat((List)commonJava.rules()).hasSize(1);
        RulesDefinition.Rule rule = commonJava.rule("coverage");
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"Lack of coverage (V2)");
        Assertions.assertThat((String)rule.markdownDescription()).isEqualTo((Object)"Coverage must be high (V2)");
        Assertions.assertThat((String)rule.htmlDescription()).isNull();
        Assertions.assertThat((List)this.logTester.logs()).isEmpty();
    }

    @Test
    public void cant_set_blank_repository_name() {
        this.context.createRepository("findbugs", "java").setName(null).done();
        Assertions.assertThat((String)this.context.repository("findbugs").name()).isEqualTo((Object)"findbugs");
    }

    @Test
    public void fail_if_duplicated_rule_keys_in_the_same_repository() {
        this.expectedException.expect(IllegalArgumentException.class);
        RulesDefinition.NewRepository findbugs = this.context.createRepository("findbugs", "java");
        findbugs.createRule("NPE");
        findbugs.createRule("NPE");
    }

    @Test
    public void fail_if_duplicated_rule_param_keys() {
        RulesDefinition.NewRule rule = this.context.createRepository("findbugs", "java").createRule("NPE");
        rule.createParam("level");
        try {
            rule.createParam("level");
            Assert.fail();
        }
        catch (Exception e) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class)).hasMessage("The parameter 'level' is declared several times on the rule [repository=findbugs, key=NPE]");
        }
    }

    @Test
    public void fail_if_blank_rule_name() {
        RulesDefinition.NewRepository newRepository = this.context.createRepository("findbugs", "java");
        newRepository.createRule("NPE").setName(null).setHtmlDescription("NPE");
        try {
            newRepository.done();
            Assert.fail();
        }
        catch (Exception e) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalStateException.class)).hasMessage("Name of rule [repository=findbugs, key=NPE] is empty");
        }
    }

    @Test
    public void fail_if_bad_rule_tag() {
        try {
            this.context.createRepository("findbugs", "java").createRule("NPE").setTags(new String[]{"coding style"});
            Assert.fail();
        }
        catch (Exception e) {
            ((AbstractThrowableAssert)Assertions.assertThat((Throwable)e).isInstanceOf(IllegalArgumentException.class)).hasMessage("Tag 'coding style' is invalid. Rule tags accept only the characters: a-z, 0-9, '+', '-', '#', '.'");
        }
    }

    @Test
    public void load_rule_html_description_from_file() {
        RulesDefinition.NewRepository newRepository = this.context.createRepository("findbugs", "java");
        newRepository.createRule("NPE").setName("NPE").setHtmlDescription(this.getClass().getResource("/org/sonar/api/server/rule/RulesDefinitionTest/sample.html"));
        newRepository.done();
        RulesDefinition.Rule rule = this.context.repository("findbugs").rule("NPE");
        Assertions.assertThat((String)rule.htmlDescription()).isEqualTo((Object)"description of rule loaded from file");
    }

    @Test
    public void load_rule_markdown_description_from_file() {
        RulesDefinition.NewRepository newRepository = this.context.createRepository("findbugs", "java");
        newRepository.createRule("NPE").setName("NPE").setMarkdownDescription(this.getClass().getResource("/org/sonar/api/server/rule/RulesDefinitionTest/sample.md"));
        newRepository.done();
        RulesDefinition.Rule rule = this.context.repository("findbugs").rule("NPE");
        Assertions.assertThat((String)rule.markdownDescription()).isEqualTo((Object)"description of rule loaded from file");
    }

    @Test
    public void fail_to_load_html_rule_description_from_file() {
        RulesDefinition.NewRepository newRepository = this.context.createRepository("findbugs", "java");
        newRepository.createRule("NPE").setName("NPE").setHtmlDescription((URL)null);
        try {
            newRepository.done();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("One of HTML description or Markdown description must be defined for rule [repository=findbugs, key=NPE]");
        }
    }

    @Test
    public void fail_to_load_markdown_rule_description_from_file() {
        RulesDefinition.NewRepository newRepository = this.context.createRepository("findbugs", "java");
        newRepository.createRule("NPE").setName("NPE").setMarkdownDescription((URL)null);
        try {
            newRepository.done();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("One of HTML description or Markdown description must be defined for rule [repository=findbugs, key=NPE]");
        }
    }

    @Test
    public void fail_if_no_rule_description() {
        RulesDefinition.NewRepository newRepository = this.context.createRepository("findbugs", "java");
        newRepository.createRule("NPE").setName("NPE");
        try {
            newRepository.done();
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("One of HTML description or Markdown description must be defined for rule [repository=findbugs, key=NPE]");
        }
    }

    @Test
    public void fail_if_rule_already_has_html_description() {
        RulesDefinition.NewRepository newRepository = this.context.createRepository("findbugs", "java");
        try {
            newRepository.createRule("NPE").setName("NPE").setHtmlDescription("polop").setMarkdownDescription("palap");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Rule '[repository=findbugs, key=NPE]' already has an HTML description");
        }
    }

    @Test
    public void fail_if_rule_already_has_markdown_description() {
        RulesDefinition.NewRepository newRepository = this.context.createRepository("findbugs", "java");
        try {
            newRepository.createRule("NPE").setName("NPE").setMarkdownDescription("palap").setHtmlDescription("polop");
            Assert.fail();
        }
        catch (IllegalStateException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Rule '[repository=findbugs, key=NPE]' already has a Markdown description");
        }
    }

    @Test
    public void fail_if_bad_rule_severity() {
        try {
            this.context.createRepository("findbugs", "java").createRule("NPE").setSeverity("VERY HIGH");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Severity of rule [repository=findbugs, key=NPE] is not correct: VERY HIGH");
        }
    }

    @Test
    public void fail_if_removed_status() {
        try {
            this.context.createRepository("findbugs", "java").createRule("NPE").setStatus(RuleStatus.REMOVED);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Status 'REMOVED' is not accepted on rule '[repository=findbugs, key=NPE]'");
        }
    }

    @Test
    public void sqale_characteristic_is_deprecated_and_is_ignored() {
        RulesDefinition.NewRepository newRepository = this.context.createRepository("findbugs", "java");
        newRepository.createRule("NPE").setName("NPE").setHtmlDescription("desc").setDebtSubCharacteristic("API_ABUSE");
        newRepository.done();
        RulesDefinition.Rule rule = this.context.repository("findbugs").rule("NPE");
        Assertions.assertThat((String)rule.debtSubCharacteristic()).isNull();
    }

    @Test
    public void type_is_defined() {
        RulesDefinition.NewRepository newRepository = this.context.createRepository("findbugs", "java");
        newRepository.createRule("NPE").setName("NPE").setHtmlDescription("desc").setType(RuleType.VULNERABILITY).setTags(new String[]{"bug", "misra"});
        newRepository.done();
        RulesDefinition.Rule rule = this.context.repository("findbugs").rule("NPE");
        Assertions.assertThat((Comparable)rule.type()).isEqualTo((Object)RuleType.VULNERABILITY);
        Assertions.assertThat((Iterable)rule.tags()).containsOnly((Object[])new String[]{"misra"});
    }

    @Test
    public void guess_type_from_tags_if_type_is_missing() {
        RulesDefinition.NewRepository newRepository = this.context.createRepository("findbugs", "java");
        newRepository.createRule("NPE").setName("NPE").setHtmlDescription("desc").setTags(new String[]{"bug", "misra"});
        newRepository.done();
        RulesDefinition.Rule rule = this.context.repository("findbugs").rule("NPE");
        Assertions.assertThat((Comparable)rule.type()).isEqualTo((Object)RuleType.BUG);
        Assertions.assertThat((Iterable)rule.tags()).containsOnly((Object[])new String[]{"misra"});
    }
}

