/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.i18n.RuleI18n;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionI18nLoader;

public class RulesDefinitionI18nLoaderTest {
    RuleI18n i18n = (RuleI18n)Mockito.mock(RuleI18n.class);
    RulesDefinitionI18nLoader loader = new RulesDefinitionI18nLoader(this.i18n);

    @Test
    public void complete_rule_name_and_description() {
        Mockito.when((Object)this.i18n.getName("squid", "S0001")).thenReturn((Object)"SOne");
        Mockito.when((Object)this.i18n.getDescription("squid", "S0001")).thenReturn((Object)"S One");
        RulesDefinition.Context context = new RulesDefinition.Context();
        RulesDefinition.NewRepository repo = context.createRepository("squid", "java");
        repo.createRule("S0001");
        this.loader.load(repo);
        repo.done();
        RulesDefinition.Rule rule = context.repository("squid").rule("S0001");
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"SOne");
        Assertions.assertThat((String)rule.htmlDescription()).isEqualTo((Object)"S One");
    }

    @Test
    public void do_not_override_if_no_bundle() {
        RulesDefinition.Context context = new RulesDefinition.Context();
        RulesDefinition.NewRepository repo = context.createRepository("squid", "java");
        repo.createRule("S0001").setName("SOne").setHtmlDescription("S One");
        this.loader.load(repo);
        repo.done();
        RulesDefinition.Rule rule = context.repository("squid").rule("S0001");
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"SOne");
        Assertions.assertThat((String)rule.htmlDescription()).isEqualTo((Object)"S One");
    }

    @Test
    public void override_existing() {
        Mockito.when((Object)this.i18n.getName("squid", "S0001")).thenReturn((Object)"SOne");
        Mockito.when((Object)this.i18n.getDescription("squid", "S0001")).thenReturn((Object)"S One");
        RulesDefinition.Context context = new RulesDefinition.Context();
        RulesDefinition.NewRepository repo = context.createRepository("squid", "java");
        repo.createRule("S0001").setName("Bad").setHtmlDescription("Bad");
        this.loader.load(repo);
        repo.done();
        RulesDefinition.Rule rule = context.repository("squid").rule("S0001");
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"SOne");
        Assertions.assertThat((String)rule.htmlDescription()).isEqualTo((Object)"S One");
    }

    @Test
    public void complete_param_description() {
        Mockito.when((Object)this.i18n.getParamDescription("squid", "S0001", "max")).thenReturn((Object)"Maximum");
        RulesDefinition.Context context = new RulesDefinition.Context();
        RulesDefinition.NewRepository repo = context.createRepository("squid", "java");
        repo.createRule("S0001").setName("SOne").setHtmlDescription("S One").createParam("max");
        this.loader.load(repo);
        repo.done();
        RulesDefinition.Rule rule = context.repository("squid").rule("S0001");
        Assertions.assertThat((String)rule.param("max").description()).isEqualTo((Object)"Maximum");
    }
}

