/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.rule.RuleStatus;
import org.sonar.api.server.rule.RuleParamType;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.server.rule.RulesDefinitionAnnotationLoader;
import org.sonar.check.Priority;
import org.sonar.check.RuleProperty;

public class RulesDefinitionAnnotationLoaderTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    RulesDefinitionAnnotationLoader annotationLoader = new RulesDefinitionAnnotationLoader();

    @Test
    public void rule_with_property() {
        RulesDefinition.Repository repository = this.load(RuleWithProperty.class);
        Assertions.assertThat((List)repository.rules()).hasSize(1);
        RulesDefinition.Rule rule = (RulesDefinition.Rule)repository.rules().get(0);
        Assertions.assertThat((String)rule.key()).isEqualTo((Object)"foo");
        Assertions.assertThat((Comparable)rule.status()).isEqualTo((Object)RuleStatus.BETA);
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"bar");
        Assertions.assertThat((String)rule.htmlDescription()).isEqualTo((Object)"Foo Bar");
        Assertions.assertThat((String)rule.severity()).isEqualTo((Object)"BLOCKER");
        Assertions.assertThat((List)rule.params()).hasSize(1);
        Assertions.assertThat((Iterable)rule.tags()).isEmpty();
        RulesDefinition.Param prop = rule.param("property");
        Assertions.assertThat((String)prop.key()).isEqualTo((Object)"property");
        Assertions.assertThat((String)prop.description()).isEqualTo((Object)"Ignore ?");
        Assertions.assertThat((String)prop.defaultValue()).isEqualTo((Object)"false");
        Assertions.assertThat((Object)prop.type()).isEqualTo((Object)RuleParamType.STRING);
    }

    @Test
    public void override_annotation_programmatically() {
        RulesDefinition.Context context = new RulesDefinition.Context();
        RulesDefinition.NewRepository newRepository = context.createRepository("squid", "java");
        RulesDefinition.NewRule newRule = this.annotationLoader.loadRule((RulesDefinition.NewExtendedRepository)newRepository, RuleWithProperty.class);
        newRule.setName("Overriden name");
        newRule.param("property").setDefaultValue("true");
        newRule.param("property").setDescription("Overriden");
        newRepository.done();
        RulesDefinition.Repository repository = context.repository("squid");
        Assertions.assertThat((List)repository.rules()).hasSize(1);
        RulesDefinition.Rule rule = (RulesDefinition.Rule)repository.rules().get(0);
        Assertions.assertThat((String)rule.key()).isEqualTo((Object)"foo");
        Assertions.assertThat((Comparable)rule.status()).isEqualTo((Object)RuleStatus.BETA);
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"Overriden name");
        Assertions.assertThat((String)rule.htmlDescription()).isEqualTo((Object)"Foo Bar");
        Assertions.assertThat((String)rule.severity()).isEqualTo((Object)"BLOCKER");
        Assertions.assertThat((List)rule.params()).hasSize(1);
        RulesDefinition.Param prop = rule.param("property");
        Assertions.assertThat((String)prop.key()).isEqualTo((Object)"property");
        Assertions.assertThat((String)prop.description()).isEqualTo((Object)"Overriden");
        Assertions.assertThat((String)prop.defaultValue()).isEqualTo((Object)"true");
        Assertions.assertThat((Object)prop.type()).isEqualTo((Object)RuleParamType.STRING);
    }

    @Test
    public void rule_with_integer_property() {
        RulesDefinition.Repository repository = this.load(RuleWithIntegerProperty.class);
        RulesDefinition.Param prop = ((RulesDefinition.Rule)repository.rules().get(0)).param("property");
        Assertions.assertThat((String)prop.description()).isEqualTo((Object)"Max");
        Assertions.assertThat((String)prop.defaultValue()).isEqualTo((Object)"12");
        Assertions.assertThat((Object)prop.type()).isEqualTo((Object)RuleParamType.INTEGER);
    }

    @Test
    public void rule_with_text_property() {
        RulesDefinition.Repository repository = this.load(RuleWithTextProperty.class);
        RulesDefinition.Param prop = ((RulesDefinition.Rule)repository.rules().get(0)).param("property");
        Assertions.assertThat((String)prop.description()).isEqualTo((Object)"text");
        Assertions.assertThat((String)prop.defaultValue()).isEqualTo((Object)"Long text");
        Assertions.assertThat((Object)prop.type()).isEqualTo((Object)RuleParamType.TEXT);
    }

    @Test
    public void should_recognize_type() {
        Assertions.assertThat((Object)RulesDefinitionAnnotationLoader.guessType(Integer.class)).isEqualTo((Object)RuleParamType.INTEGER);
        Assertions.assertThat((Object)RulesDefinitionAnnotationLoader.guessType(Integer.TYPE)).isEqualTo((Object)RuleParamType.INTEGER);
        Assertions.assertThat((Object)RulesDefinitionAnnotationLoader.guessType(Float.class)).isEqualTo((Object)RuleParamType.FLOAT);
        Assertions.assertThat((Object)RulesDefinitionAnnotationLoader.guessType(Float.TYPE)).isEqualTo((Object)RuleParamType.FLOAT);
        Assertions.assertThat((Object)RulesDefinitionAnnotationLoader.guessType(Boolean.class)).isEqualTo((Object)RuleParamType.BOOLEAN);
        Assertions.assertThat((Object)RulesDefinitionAnnotationLoader.guessType(Boolean.TYPE)).isEqualTo((Object)RuleParamType.BOOLEAN);
        Assertions.assertThat((Object)RulesDefinitionAnnotationLoader.guessType(String.class)).isEqualTo((Object)RuleParamType.STRING);
        Assertions.assertThat((Object)RulesDefinitionAnnotationLoader.guessType(Object.class)).isEqualTo((Object)RuleParamType.STRING);
    }

    @Test
    public void use_classname_when_missing_key() {
        RulesDefinition.Repository repository = this.load(RuleWithoutKey.class);
        Assertions.assertThat((List)repository.rules()).hasSize(1);
        RulesDefinition.Rule rule = (RulesDefinition.Rule)repository.rules().get(0);
        Assertions.assertThat((String)rule.key()).isEqualTo((Object)RuleWithoutKey.class.getCanonicalName());
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"foo");
    }

    @Test
    public void rule_with_tags() {
        RulesDefinition.Repository repository = this.load(RuleWithTags.class);
        Assertions.assertThat((List)repository.rules()).hasSize(1);
        RulesDefinition.Rule rule = (RulesDefinition.Rule)repository.rules().get(0);
        Assertions.assertThat((Iterable)rule.tags()).containsOnly((Object[])new String[]{"misra", "clumsy"});
    }

    @Test
    public void overridden_class() {
        RulesDefinition.Repository repository = this.load(OverridingRule.class);
        Assertions.assertThat((List)repository.rules()).hasSize(1);
        RulesDefinition.Rule rule = (RulesDefinition.Rule)repository.rules().get(0);
        Assertions.assertThat((String)rule.key()).isEqualTo((Object)"overriding_foo");
        Assertions.assertThat((String)rule.name()).isEqualTo((Object)"Overriding Foo");
        Assertions.assertThat((String)rule.severity()).isEqualTo((Object)"MAJOR");
        Assertions.assertThat((String)rule.htmlDescription()).isEqualTo((Object)"Desc of Overriding Foo");
        Assertions.assertThat((List)rule.params()).hasSize(2);
    }

    private RulesDefinition.Repository load(Class annotatedClass) {
        RulesDefinition.Context context = new RulesDefinition.Context();
        RulesDefinition.NewRepository newRepository = context.createRepository("squid", "java");
        this.annotationLoader.load((RulesDefinition.NewExtendedRepository)newRepository, new Class[]{annotatedClass});
        newRepository.done();
        return context.repository("squid");
    }

    @org.sonar.check.Rule(key="foo", name="bar", description="Bar", tags={"misra", "clumsy"})
    static class RuleWithTags {
        RuleWithTags() {
        }
    }

    @org.sonar.check.Rule(key="foo", name="bar", description="Foo Bar", priority=Priority.BLOCKER)
    static class RuleWithInvalidPropertyType {
        @RuleProperty(description="text", defaultValue="Long text", type="INVALID")
        public String property;

        RuleWithInvalidPropertyType() {
        }
    }

    @org.sonar.check.Rule(key="foo", name="bar", description="Foo Bar", priority=Priority.BLOCKER)
    static class RuleWithTextProperty {
        @RuleProperty(description="text", defaultValue="Long text", type="TEXT")
        protected String property;

        RuleWithTextProperty() {
        }
    }

    @org.sonar.check.Rule(key="foo", name="bar", description="Foo Bar", priority=Priority.BLOCKER)
    static class RuleWithIntegerProperty {
        @RuleProperty(description="Max", defaultValue="12")
        private Integer property;

        RuleWithIntegerProperty() {
        }
    }

    @org.sonar.check.Rule(key="overriding_foo", name="Overriding Foo", description="Desc of Overriding Foo")
    static class OverridingRule
    extends RuleWithProperty {
        @RuleProperty
        private String additionalProperty;

        OverridingRule() {
        }
    }

    @org.sonar.check.Rule(key="foo", name="bar", description="Foo Bar", priority=Priority.BLOCKER, status="BETA")
    static class RuleWithProperty {
        @RuleProperty(description="Ignore ?", defaultValue="false")
        private String property;

        RuleWithProperty() {
        }
    }

    @org.sonar.check.Rule(name="foo", description="Foo")
    static class RuleWithoutKey {
        RuleWithoutKey() {
        }
    }
}

