/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.rules.RuleType;
import org.sonar.api.server.rule.RuleTagsToTypeConverter;
import org.sonar.test.TestUtils;

public class RuleTagsToTypeConverterTest {
    @Test
    public void type_is_bug_if_has_tag_bug() {
        Assertions.assertThat((Comparable)RuleTagsToTypeConverter.convert(Arrays.asList("misra", "bug"))).isEqualTo((Object)RuleType.BUG);
        Assertions.assertThat((Comparable)RuleTagsToTypeConverter.convert(Arrays.asList("security", "bug"))).isEqualTo((Object)RuleType.BUG);
    }

    @Test
    public void type_is_vulnerability_if_has_tag_security() {
        Assertions.assertThat((Comparable)RuleTagsToTypeConverter.convert(Arrays.asList("misra", "security"))).isEqualTo((Object)RuleType.VULNERABILITY);
    }

    @Test
    public void default_is_code_smell() {
        Assertions.assertThat((Comparable)RuleTagsToTypeConverter.convert(Arrays.asList("clumsy", "spring"))).isEqualTo((Object)RuleType.CODE_SMELL);
        Assertions.assertThat((Comparable)RuleTagsToTypeConverter.convert(Collections.emptyList())).isEqualTo((Object)RuleType.CODE_SMELL);
    }

    @Test
    public void only_statics() {
        Assertions.assertThat((boolean)TestUtils.hasOnlyPrivateConstructors(RuleTagsToTypeConverter.class)).isTrue();
    }
}

