/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.server.rule.RuleTagFormat;

public class RuleTagFormatTest {
    @Test
    public void isValid() {
        Assertions.assertThat((boolean)RuleTagFormat.isValid(null)).isFalse();
        Assertions.assertThat((boolean)RuleTagFormat.isValid((String)"")).isFalse();
        Assertions.assertThat((boolean)RuleTagFormat.isValid((String)" ")).isFalse();
        Assertions.assertThat((boolean)RuleTagFormat.isValid((String)"coding style")).isFalse();
        Assertions.assertThat((boolean)RuleTagFormat.isValid((String)"Style")).isFalse();
        Assertions.assertThat((boolean)RuleTagFormat.isValid((String)"sTyle")).isFalse();
        Assertions.assertThat((boolean)RuleTagFormat.isValid((String)"@style")).isFalse();
        Assertions.assertThat((boolean)RuleTagFormat.isValid((String)"style")).isTrue();
        Assertions.assertThat((boolean)RuleTagFormat.isValid((String)"c++")).isTrue();
        Assertions.assertThat((boolean)RuleTagFormat.isValid((String)"f#")).isTrue();
        Assertions.assertThat((boolean)RuleTagFormat.isValid((String)"c++11")).isTrue();
        Assertions.assertThat((boolean)RuleTagFormat.isValid((String)"c.d")).isTrue();
    }

    @Test
    public void validate() {
        RuleTagFormat.validate((String)"style");
    }

    @Test
    public void validate_and_fail() {
        try {
            RuleTagFormat.validate((String)"  ");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Tag '  ' is invalid. Rule tags accept only the characters: a-z, 0-9, '+', '-', '#', '.'");
        }
    }
}

