/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import java.util.List;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.server.rule.RuleParamType;

public class RuleParamTypeTest {
    @Test
    public void testEquals() throws Exception {
        RuleParamType noOptions = RuleParamType.INTEGER;
        RuleParamType withOptions1 = RuleParamType.singleListOfValues((String[])new String[]{"one", "two"});
        RuleParamType withOptions2 = RuleParamType.singleListOfValues((String[])new String[]{"three", "four"});
        ((AbstractObjectAssert)((AbstractObjectAssert)((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)RuleParamType.INTEGER).isEqualTo((Object)RuleParamType.INTEGER)).isNotEqualTo((Object)RuleParamType.STRING)).isNotEqualTo((Object)"INTEGER")).isNotEqualTo((Object)withOptions1)).isNotEqualTo(null);
        ((AbstractObjectAssert)((AbstractObjectAssert)((AbstractObjectAssert)((AbstractObjectAssert)Assertions.assertThat((Object)withOptions1).isEqualTo((Object)withOptions1)).isNotEqualTo((Object)noOptions)).isNotEqualTo((Object)withOptions2)).isNotEqualTo((Object)"SINGLE_SELECT_LIST,values=one,two,")).isNotEqualTo(null);
    }

    @Test
    public void testHashCode() throws Exception {
        Assertions.assertThat((int)RuleParamType.INTEGER.hashCode()).isEqualTo(RuleParamType.INTEGER.hashCode());
    }

    @Test
    public void testInteger() throws Exception {
        RuleParamType type = RuleParamType.INTEGER;
        Assertions.assertThat((String)type.toString()).isEqualTo((Object)"INTEGER");
        Assertions.assertThat((String)RuleParamType.parse((String)type.toString()).type()).isEqualTo((Object)"INTEGER");
        Assertions.assertThat((List)RuleParamType.parse((String)type.toString()).values()).isEmpty();
        Assertions.assertThat((String)RuleParamType.parse((String)type.toString()).toString()).isEqualTo((Object)"INTEGER");
    }

    @Test
    public void testListOfValues() throws Exception {
        RuleParamType selectList = RuleParamType.parse((String)"SINGLE_SELECT_LIST,values=\"foo,bar\",");
        Assertions.assertThat((String)selectList.type()).isEqualTo((Object)"SINGLE_SELECT_LIST");
        Assertions.assertThat((List)selectList.values()).containsOnly((Object[])new String[]{"foo", "bar"});
        Assertions.assertThat((boolean)selectList.multiple()).isFalse();
        Assertions.assertThat((String)selectList.toString()).isEqualTo((Object)"SINGLE_SELECT_LIST,values=\"foo,bar,\"");
        RuleParamType.parse((String)"SINGLE_SELECT_LIST,values=\"foo,bar\",multiple=false");
        Assertions.assertThat((String)selectList.type()).isEqualTo((Object)"SINGLE_SELECT_LIST");
        Assertions.assertThat((List)selectList.values()).containsOnly((Object[])new String[]{"foo", "bar"});
        Assertions.assertThat((boolean)selectList.multiple()).isFalse();
        Assertions.assertThat((String)selectList.toString()).isEqualTo((Object)"SINGLE_SELECT_LIST,values=\"foo,bar,\"");
        RuleParamType.parse((String)"SINGLE_SELECT_LIST,\"values=foo,bar\",\"multiple=false\"");
        Assertions.assertThat((String)selectList.type()).isEqualTo((Object)"SINGLE_SELECT_LIST");
        Assertions.assertThat((List)selectList.values()).containsOnly((Object[])new String[]{"foo", "bar"});
        Assertions.assertThat((boolean)selectList.multiple()).isFalse();
        Assertions.assertThat((String)selectList.toString()).isEqualTo((Object)"SINGLE_SELECT_LIST,values=\"foo,bar,\"");
        selectList = RuleParamType.singleListOfValues((String[])new String[]{"foo", "one,two|three,four"});
        Assertions.assertThat((String)selectList.type()).isEqualTo((Object)"SINGLE_SELECT_LIST");
        Assertions.assertThat((List)selectList.values()).containsOnly((Object[])new String[]{"foo", "one,two|three,four"});
        Assertions.assertThat((boolean)selectList.multiple()).isFalse();
        Assertions.assertThat((String)selectList.toString()).isEqualTo((Object)"SINGLE_SELECT_LIST,values=\"foo,\"\"one,two|three,four\"\",\"");
    }

    @Test
    public void testMultipleListOfValues() throws Exception {
        RuleParamType selectList = RuleParamType.parse((String)"SINGLE_SELECT_LIST,values=\"foo,bar\",multiple=true");
        Assertions.assertThat((String)selectList.type()).isEqualTo((Object)"SINGLE_SELECT_LIST");
        Assertions.assertThat((List)selectList.values()).containsOnly((Object[])new String[]{"foo", "bar"});
        Assertions.assertThat((boolean)selectList.multiple()).isTrue();
        Assertions.assertThat((String)selectList.toString()).isEqualTo((Object)"SINGLE_SELECT_LIST,multiple=true,values=\"foo,bar,\"");
        RuleParamType.parse((String)"SINGLE_SELECT_LIST,\"values=foo,bar\",\"multiple=true\"");
        Assertions.assertThat((String)selectList.type()).isEqualTo((Object)"SINGLE_SELECT_LIST");
        Assertions.assertThat((List)selectList.values()).containsOnly((Object[])new String[]{"foo", "bar"});
        Assertions.assertThat((boolean)selectList.multiple()).isTrue();
        Assertions.assertThat((String)selectList.toString()).isEqualTo((Object)"SINGLE_SELECT_LIST,multiple=true,values=\"foo,bar,\"");
        selectList = RuleParamType.multipleListOfValues((String[])new String[]{"foo", "one,two|three,four"});
        Assertions.assertThat((String)selectList.type()).isEqualTo((Object)"SINGLE_SELECT_LIST");
        Assertions.assertThat((List)selectList.values()).containsOnly((Object[])new String[]{"foo", "one,two|three,four"});
        Assertions.assertThat((boolean)selectList.multiple()).isTrue();
        Assertions.assertThat((String)selectList.toString()).isEqualTo((Object)"SINGLE_SELECT_LIST,multiple=true,values=\"foo,\"\"one,two|three,four\"\",\"");
    }

    @Test
    public void support_deprecated_formats() {
        Assertions.assertThat((Object)RuleParamType.parse((String)"b")).isEqualTo((Object)RuleParamType.BOOLEAN);
        Assertions.assertThat((Object)RuleParamType.parse((String)"i")).isEqualTo((Object)RuleParamType.INTEGER);
        Assertions.assertThat((Object)RuleParamType.parse((String)"i{}")).isEqualTo((Object)RuleParamType.INTEGER);
        Assertions.assertThat((Object)RuleParamType.parse((String)"s")).isEqualTo((Object)RuleParamType.STRING);
        Assertions.assertThat((Object)RuleParamType.parse((String)"s{}")).isEqualTo((Object)RuleParamType.STRING);
        Assertions.assertThat((Object)RuleParamType.parse((String)"r")).isEqualTo((Object)RuleParamType.STRING);
        Assertions.assertThat((Object)RuleParamType.parse((String)"TEXT")).isEqualTo((Object)RuleParamType.TEXT);
        Assertions.assertThat((Object)RuleParamType.parse((String)"STRING")).isEqualTo((Object)RuleParamType.STRING);
        Assertions.assertThat((Object)RuleParamType.parse((String)"REGULAR_EXPRESSION")).isEqualTo((Object)RuleParamType.STRING);
        RuleParamType list = RuleParamType.parse((String)"s[FOO,BAR]");
        Assertions.assertThat((String)list.type()).isEqualTo((Object)"SINGLE_SELECT_LIST");
        Assertions.assertThat((List)list.values()).containsOnly((Object[])new String[]{"FOO", "BAR"});
    }
}

