/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.debt;

import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.server.debt.DebtRemediationFunction;
import org.sonar.api.server.debt.internal.DefaultDebtRemediationFunction;

public class DefaultDebtRemediationFunctionTest {
    @Test
    public void create_linear() {
        DefaultDebtRemediationFunction function = new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR, "10h", null);
        Assertions.assertThat((Comparable)function.type()).isEqualTo((Object)DebtRemediationFunction.Type.LINEAR);
        Assertions.assertThat((String)function.gapMultiplier()).isEqualTo((Object)"10h");
        Assertions.assertThat((String)function.baseEffort()).isNull();
    }

    @Test
    public void create_linear_with_offset() {
        DefaultDebtRemediationFunction function = new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR_OFFSET, "10h", "5min");
        Assertions.assertThat((Comparable)function.type()).isEqualTo((Object)DebtRemediationFunction.Type.LINEAR_OFFSET);
        Assertions.assertThat((String)function.gapMultiplier()).isEqualTo((Object)"10h");
        Assertions.assertThat((String)function.baseEffort()).isEqualTo((Object)"5min");
    }

    @Test
    public void create_constant_per_issue() {
        DefaultDebtRemediationFunction function = new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.CONSTANT_ISSUE, null, "10h");
        Assertions.assertThat((Comparable)function.type()).isEqualTo((Object)DebtRemediationFunction.Type.CONSTANT_ISSUE);
        Assertions.assertThat((String)function.gapMultiplier()).isNull();
        Assertions.assertThat((String)function.baseEffort()).isEqualTo((Object)"10h");
    }

    @Test
    public void sanitize_remediation_coefficient_and_offset() {
        DefaultDebtRemediationFunction function = new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR_OFFSET, "  1  h   ", "  10   min");
        Assertions.assertThat((String)function.gapMultiplier()).isEqualTo((Object)"1h");
        Assertions.assertThat((String)function.baseEffort()).isEqualTo((Object)"10min");
    }

    @Test
    public void fail_to_when_no_type() {
        try {
            new DefaultDebtRemediationFunction(null, "5min", "10h");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Remediation function type cannot be null");
        }
    }

    @Test
    public void fail_to_create_linear_when_no_coefficient() {
        try {
            new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR, null, "10h");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Linear functions must only have a non empty gap multiplier");
        }
    }

    @Test
    public void fail_to_create_linear_when_offset() {
        try {
            new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR, "5min", "10h");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Linear functions must only have a non empty gap multiplier");
        }
    }

    @Test
    public void fail_to_create_constant_per_issue_when_no_offset() {
        try {
            new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.CONSTANT_ISSUE, "10h", null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Constant/issue functions must only have a non empty base effort");
        }
    }

    @Test
    public void fail_to_create_constant_per_issue_when_coefficient() {
        try {
            new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.CONSTANT_ISSUE, "5min", "10h");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Constant/issue functions must only have a non empty base effort");
        }
    }

    @Test
    public void fail_to_create_linear_with_offset_when_no_coefficient() {
        try {
            new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR_OFFSET, "", "10h");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Linear with offset functions must have both non null gap multiplier and base effort");
        }
    }

    @Test
    public void fail_to_create_linear_with_offset_when_no_offset() {
        try {
            new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR_OFFSET, "5min", "");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Linear with offset functions must have both non null gap multiplier and base effort");
        }
    }

    @Test
    public void test_equals_and_hashcode() {
        DefaultDebtRemediationFunction function = new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR_OFFSET, "10h", "5min");
        DefaultDebtRemediationFunction functionWithSameValue = new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR_OFFSET, "10h", "5min");
        DefaultDebtRemediationFunction functionWithDifferentType = new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.CONSTANT_ISSUE, null, "5min");
        Assertions.assertThat((Object)function).isEqualTo((Object)function);
        Assertions.assertThat((Object)function).isEqualTo((Object)functionWithSameValue);
        Assertions.assertThat((Object)function).isNotEqualTo((Object)functionWithDifferentType);
        Assertions.assertThat((Object)function).isNotEqualTo((Object)new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR_OFFSET, "11h", "5min"));
        Assertions.assertThat((Object)function).isNotEqualTo((Object)new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR_OFFSET, "10h", "6min"));
        Assertions.assertThat((Object)function).isNotEqualTo((Object)new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR, "10h", null));
        Assertions.assertThat((Object)function).isNotEqualTo((Object)new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.CONSTANT_ISSUE, null, "6min"));
        Assertions.assertThat((int)function.hashCode()).isEqualTo(function.hashCode());
        Assertions.assertThat((int)function.hashCode()).isEqualTo(functionWithSameValue.hashCode());
        Assertions.assertThat((int)function.hashCode()).isNotEqualTo(functionWithDifferentType.hashCode());
    }

    @Test
    public void test_to_string() {
        Assertions.assertThat((String)new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR_OFFSET, "10h", "5min").toString()).isEqualTo((Object)"DebtRemediationFunction{type=LINEAR_OFFSET, gap multiplier=10h, base effort=5min}");
    }

    @Test
    public void fail_if_bad_coefficient_format() {
        try {
            new DefaultDebtRemediationFunction(DebtRemediationFunction.Type.LINEAR, "foo", null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Invalid gap multiplier: foo (Duration 'foo' is invalid, it should use the following sample format : 2d 10h 15min)");
        }
    }
}

