/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.authentication;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.server.authentication.UserIdentity;

public class UserIdentityTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void create_user() throws Exception {
        UserIdentity underTest = UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName("John").setEmail("john@email.com").build();
        Assertions.assertThat((String)underTest.getProviderLogin()).isEqualTo((Object)"john");
        Assertions.assertThat((String)underTest.getLogin()).isEqualTo((Object)"1234");
        Assertions.assertThat((String)underTest.getName()).isEqualTo((Object)"John");
        Assertions.assertThat((String)underTest.getEmail()).isEqualTo((Object)"john@email.com");
        Assertions.assertThat((boolean)underTest.shouldSyncGroups()).isFalse();
        Assertions.assertThat((Iterable)underTest.getGroups()).isEmpty();
    }

    @Test
    public void create_user_without_email() throws Exception {
        UserIdentity underTest = UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName("John").build();
        Assertions.assertThat((String)underTest.getEmail()).isNull();
    }

    @Test
    public void fail_when_login_is_empty() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("User login must not be blank");
        UserIdentity.builder().setProviderLogin("john").setLogin("").setName("John").setEmail("john@email.com").build();
    }

    @Test
    public void fail_when_login_is_too_long() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("User login size is incorrect (Between 2 and 255 characters)");
        UserIdentity.builder().setProviderLogin("john").setLogin(Strings.repeat((String)"1", (int)256)).setName("John").setEmail("john@email.com").build();
    }

    @Test
    public void fail_when_login_is_too_small() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("User login size is incorrect (Between 2 and 255 characters)");
        UserIdentity.builder().setProviderLogin("john").setLogin("j").setName("John").setEmail("john@email.com").build();
    }

    @Test
    public void fail_when_provider_login_is_null() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Provider login must not be blank");
        UserIdentity.builder().setLogin("1234").setName("John").setEmail("john@email.com").build();
    }

    @Test
    public void fail_when_provider_login_is_empty() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Provider login must not be blank");
        UserIdentity.builder().setProviderLogin("").setLogin("1234").setName("John").setEmail("john@email.com").build();
    }

    @Test
    public void fail_when_provider_login_is_too_long() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Provider login size is incorrect (maximum 255 characters)");
        UserIdentity.builder().setProviderLogin(Strings.repeat((String)"1", (int)256)).setLogin("1234").setName("John").setEmail("john@email.com").build();
    }

    @Test
    public void fail_when_name_is_null() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("User name must not be blank");
        UserIdentity.builder().setProviderLogin("john").setLogin("1234").setEmail("john@email.com").build();
    }

    @Test
    public void fail_when_name_is_empty() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("User name must not be blank");
        UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName("").setEmail("john@email.com").build();
    }

    @Test
    public void fail_when_name_is_loo_long() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("User name size is too big (200 characters max)");
        UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName(Strings.repeat((String)"1", (int)201)).setEmail("john@email.com").build();
    }

    @Test
    public void fail_when_email_is_loo_long() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("User email size is too big (100 characters max)");
        UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName("John").setEmail(Strings.repeat((String)"1", (int)101)).build();
    }

    @Test
    public void create_user_with_groups() throws Exception {
        UserIdentity underTest = UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName("John").setEmail("john@email.com").setGroups((Set)Sets.newHashSet((Object[])new String[]{"admin", "user"})).build();
        Assertions.assertThat((boolean)underTest.shouldSyncGroups()).isTrue();
        Assertions.assertThat((Iterable)underTest.getGroups()).containsOnly((Object[])new String[]{"admin", "user"});
    }

    @Test
    public void fail_when_groups_are_null() throws Exception {
        this.thrown.expect(NullPointerException.class);
        this.thrown.expectMessage("Groups cannot be null, please don't use this method if groups should not be synchronized.");
        UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName("John").setEmail("john@email.com").setGroups(null);
    }

    @Test
    public void fail_when_groups_contain_empty_group_name() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Group name cannot be empty");
        UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName("John").setEmail("john@email.com").setGroups((Set)Sets.newHashSet((Object[])new String[]{""}));
    }

    @Test
    public void fail_when_groups_contain_only_blank_space() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Group name cannot be empty");
        UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName("John").setEmail("john@email.com").setGroups((Set)Sets.newHashSet((Object[])new String[]{"      "}));
    }

    @Test
    public void fail_when_groups_contain_null_group_name() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Group name cannot be empty");
        UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName("John").setEmail("john@email.com").setGroups((Set)Sets.newHashSet((Object[])new String[]{null}));
    }

    @Test
    public void fail_when_groups_contain_anyone() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Anyone group cannot be used");
        UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName("John").setEmail("john@email.com").setGroups((Set)Sets.newHashSet((Object[])new String[]{"Anyone"}));
    }

    @Test
    public void fail_when_groups_contain_too_long_group_name() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Group name cannot be longer than 255 characters");
        UserIdentity.builder().setProviderLogin("john").setLogin("1234").setName("John").setEmail("john@email.com").setGroups((Set)Sets.newHashSet((Object[])new String[]{Strings.repeat((String)"group", (int)300)}));
    }
}

