/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.authentication;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.server.authentication.Display;

public class DisplayTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void create_display() throws Exception {
        Display display = Display.builder().setIconPath("/static/authgithub/github.svg").setBackgroundColor("#123456").build();
        Assertions.assertThat((String)display.getIconPath()).isEqualTo((Object)"/static/authgithub/github.svg");
        Assertions.assertThat((String)display.getBackgroundColor()).isEqualTo((Object)"#123456");
    }

    @Test
    public void create_display_with_default_background_color() throws Exception {
        Display display = Display.builder().setIconPath("/static/authgithub/github.svg").build();
        Assertions.assertThat((String)display.getBackgroundColor()).isEqualTo((Object)"#236a97");
    }

    @Test
    public void fail_when_icon_path_is_null() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Icon path must not be blank");
        Display.builder().setIconPath(null).setBackgroundColor("#123456").build();
    }

    @Test
    public void fail_when_icon_path_is_blank() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Icon path must not be blank");
        Display.builder().setIconPath("").setBackgroundColor("#123456").build();
    }

    @Test
    public void fail_when_background_color_is_null() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Background color must not be blank");
        Display.builder().setIconPath("/static/authgithub/github.svg").setBackgroundColor(null).build();
    }

    @Test
    public void fail_when_background_color_is_blank() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Background color must not be blank");
        Display.builder().setIconPath("/static/authgithub/github.svg").setBackgroundColor("").build();
    }

    @Test
    public void fail_when_background_color_has_wrong_size() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Background color must begin with a sharp followed by 6 characters");
        Display.builder().setIconPath("/static/authgithub/github.svg").setBackgroundColor("#1234").build();
    }

    @Test
    public void fail_when_background_color_doesnt_begin_with_sharp() throws Exception {
        this.thrown.expect(IllegalArgumentException.class);
        this.thrown.expectMessage("Background color must begin with a sharp followed by 6 characters");
        Display.builder().setIconPath("/static/authgithub/github.svg").setBackgroundColor("*123456").build();
    }
}

