/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.security;

import javax.servlet.http.HttpServletRequest;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.security.Authenticator;
import org.sonar.api.security.LoginPasswordAuthenticator;
import org.sonar.api.security.SecurityRealm;

public class SecurityRealmTest {
    @Test
    public void doGetAuthenticator() {
        final Authenticator authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        SecurityRealm realm = new SecurityRealm(){

            public Authenticator doGetAuthenticator() {
                return authenticator;
            }
        };
        Assertions.assertThat((Object)realm.doGetAuthenticator()).isSameAs((Object)authenticator);
        Assertions.assertThat((Object)realm.getLoginPasswordAuthenticator()).isNull();
    }

    @Test
    public void getLoginPasswordAuthenticator_deprecated_method_replaced_by_getAuthenticator() {
        final LoginPasswordAuthenticator deprecatedAuthenticator = (LoginPasswordAuthenticator)Mockito.mock(LoginPasswordAuthenticator.class);
        SecurityRealm realm = new SecurityRealm(){

            public LoginPasswordAuthenticator getLoginPasswordAuthenticator() {
                return deprecatedAuthenticator;
            }
        };
        Authenticator proxy = realm.doGetAuthenticator();
        Authenticator.Context context = new Authenticator.Context("foo", "bar", (HttpServletRequest)Mockito.mock(HttpServletRequest.class));
        proxy.doAuthenticate(context);
        ((LoginPasswordAuthenticator)Mockito.verify((Object)deprecatedAuthenticator)).authenticate("foo", "bar");
    }
}

