/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.security;

import com.google.common.base.Preconditions;
import javax.servlet.http.HttpServletRequest;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.security.ExternalUsersProvider;
import org.sonar.api.security.UserDetails;

public class ExternalUsersProviderTest {
    @Test
    public void doGetUserDetails() {
        ExternalUsersProvider provider = new ExternalUsersProvider(){

            public UserDetails doGetUserDetails(ExternalUsersProvider.Context context) {
                Preconditions.checkNotNull((Object)context.getUsername());
                Preconditions.checkNotNull((Object)context.getRequest());
                UserDetails user = new UserDetails();
                user.setName(context.getUsername());
                user.setEmail("foo@bar.com");
                return user;
            }
        };
        UserDetails user = provider.doGetUserDetails(new ExternalUsersProvider.Context("foo", (HttpServletRequest)Mockito.mock(HttpServletRequest.class)));
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)user.getEmail()).isEqualTo((Object)"foo@bar.com");
    }

    @Test
    public void doGetUserDetails_deprecated_api() {
        ExternalUsersProvider provider = new ExternalUsersProvider(){

            public UserDetails doGetUserDetails(String username) {
                UserDetails user = new UserDetails();
                user.setName(username);
                user.setEmail("foo@bar.com");
                return user;
            }
        };
        UserDetails user = provider.doGetUserDetails(new ExternalUsersProvider.Context("foo", (HttpServletRequest)Mockito.mock(HttpServletRequest.class)));
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)user.getEmail()).isEqualTo((Object)"foo@bar.com");
    }
}

