/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.security;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.security.ExternalGroupsProvider;

public class ExternalGroupsProviderTest {
    @Test
    public void doGetGroupsNoOverride() {
        ExternalGroupsProvider groupsProvider = new ExternalGroupsProvider(){};
        String userName = "foo";
        Assertions.assertThat((Iterable)groupsProvider.doGetGroups(userName)).isNull();
        Assertions.assertThat((Iterable)groupsProvider.doGetGroups(new ExternalGroupsProvider.Context(userName, (HttpServletRequest)Mockito.mock(HttpServletRequest.class)))).isNull();
    }

    @Test
    public void doGetGroupsTests() {
        final Map<String, Collection<String>> userGroupsMap = ExternalGroupsProviderTest.getTestUserGroupMapping();
        ExternalGroupsProvider groupsProvider = new ExternalGroupsProvider(){

            public Collection<String> doGetGroups(ExternalGroupsProvider.Context context) {
                Preconditions.checkNotNull((Object)context.getUsername());
                Preconditions.checkNotNull((Object)context.getRequest());
                return (Collection)userGroupsMap.get(context.getUsername());
            }
        };
        ExternalGroupsProviderTest.runDoGetGroupsTests(groupsProvider, userGroupsMap);
    }

    @Test
    public void doGetGroupsDeprecatedApi() {
        final Map<String, Collection<String>> userGroupsMap = ExternalGroupsProviderTest.getTestUserGroupMapping();
        ExternalGroupsProvider groupsProvider = new ExternalGroupsProvider(){

            public Collection<String> doGetGroups(String username) {
                Preconditions.checkNotNull((Object)username);
                return (Collection)userGroupsMap.get(username);
            }
        };
        ExternalGroupsProviderTest.runDoGetGroupsTests(groupsProvider, userGroupsMap);
    }

    private static void runDoGetGroupsTests(ExternalGroupsProvider groupsProvider, Map<String, Collection<String>> userGroupsMap) {
        for (Map.Entry<String, Collection<String>> userGroupMapEntry : userGroupsMap.entrySet()) {
            Collection groups = groupsProvider.doGetGroups(new ExternalGroupsProvider.Context(userGroupMapEntry.getKey(), (HttpServletRequest)Mockito.mock(HttpServletRequest.class)));
            Assertions.assertThat((Iterable)groups).isEqualTo(userGroupMapEntry.getValue());
        }
    }

    private static Map<String, Collection<String>> getTestUserGroupMapping() {
        HashMap<String, Collection<String>> userGroupsMap = new HashMap<String, Collection<String>>();
        ExternalGroupsProviderTest.addUserGroupMapping(userGroupsMap, "userWithOneGroups", new String[]{"group1"});
        ExternalGroupsProviderTest.addUserGroupMapping(userGroupsMap, "userWithTwoGroups", new String[]{"group1", "group2"});
        ExternalGroupsProviderTest.addUserGroupMapping(userGroupsMap, "userWithNoGroup", new String[0]);
        ExternalGroupsProviderTest.addUserGroupMapping(userGroupsMap, "userWithNullGroup", null);
        return userGroupsMap;
    }

    private static void addUserGroupMapping(Map<String, Collection<String>> userGroupsMap, String user, @Nullable String[] groups) {
        ArrayList<String> groupsCollection = null;
        if (groups != null) {
            groupsCollection = new ArrayList<String>();
            groupsCollection.addAll(Arrays.asList(groups));
        }
        userGroupsMap.put(user, groupsCollection);
    }
}

