/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.SystemUtils;
import org.assertj.core.api.Assertions;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.sonar.api.scan.filesystem.PathResolver;

public class PathResolverTest {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void get_file_by_relative_path() throws IOException {
        PathResolver resolver = new PathResolver();
        File rootDir = this.temp.newFolder();
        File file = resolver.relativeFile(rootDir, "org/foo/Bar.java");
        Assertions.assertThat((String)file.getName()).isEqualTo((Object)"Bar.java");
        Assertions.assertThat((String)FilenameUtils.separatorsToUnix((String)file.getCanonicalPath())).endsWith((CharSequence)"org/foo/Bar.java");
        Assertions.assertThat((String)file.getParentFile().getParentFile().getParentFile().getCanonicalPath()).isEqualTo((Object)rootDir.getCanonicalPath());
    }

    @Test
    public void get_file_by_absolute_path() throws IOException {
        PathResolver resolver = new PathResolver();
        File rootDir = this.temp.newFolder();
        File file = resolver.relativeFile(rootDir, new File(rootDir, "org/foo/Bar.java").getAbsolutePath());
        Assertions.assertThat((String)file.getName()).isEqualTo((Object)"Bar.java");
        Assertions.assertThat((String)FilenameUtils.separatorsToUnix((String)file.getCanonicalPath())).endsWith((CharSequence)"org/foo/Bar.java");
        Assertions.assertThat((String)file.getParentFile().getParentFile().getParentFile().getCanonicalPath()).isEqualTo((Object)rootDir.getCanonicalPath());
    }

    @Test
    public void get_files_by_relative_paths() throws IOException {
        PathResolver resolver = new PathResolver();
        File rootDir = this.temp.newFolder();
        List files = resolver.relativeFiles(rootDir, Arrays.asList("org/foo/Bar.java", "org/hello/World.java"));
        Assertions.assertThat((List)files).hasSize(2);
        for (File file : files) {
            Assertions.assertThat((String)file.getName()).endsWith((CharSequence)".java");
            Assertions.assertThat((String)file.getParentFile().getParentFile().getParentFile().getCanonicalPath()).isEqualTo((Object)rootDir.getCanonicalPath());
        }
    }

    @Test
    public void relative_path_from_dir() throws IOException {
        PathResolver resolver = new PathResolver();
        File rootDir = this.temp.newFolder();
        File org = new File(rootDir, "org");
        File hello = new File(org, "hello");
        File world = new File(hello, "World.java");
        Assertions.assertThat((String)resolver.relativePath(rootDir, world)).isEqualTo((Object)"org/hello/World.java");
        Assertions.assertThat((String)resolver.relativePath(new File(rootDir, "."), world)).isEqualTo((Object)"org/hello/World.java");
    }

    @Test
    public void relative_path_from_not_normalized_dir() throws IOException {
        PathResolver resolver = new PathResolver();
        File rootDir = new File(this.temp.newFolder(), "foo/..");
        File org = new File(rootDir, "org");
        File hello = new File(org, "hello");
        File world = new File(hello, "World.java");
        Assertions.assertThat((String)resolver.relativePath(rootDir, world)).isEqualTo((Object)"org/hello/World.java");
    }

    @Test
    public void relative_path_for_not_normalized_dir() throws IOException {
        PathResolver resolver = new PathResolver();
        File rootDir = this.temp.newFolder();
        File file = new File(rootDir, "level1/../dir/file.c");
        Assertions.assertThat((String)resolver.relativePath(rootDir, file)).isEqualTo((Object)"dir/file.c");
    }

    @Test
    public void relative_path_for_not_normalized_dir_sub_level() throws IOException {
        PathResolver resolver = new PathResolver();
        File rootDir = this.temp.newFolder();
        File file = new File(rootDir, "level1/level2/../dir/file.c");
        Assertions.assertThat((String)resolver.relativePath(rootDir, file)).isEqualTo((Object)"level1/dir/file.c");
    }

    @Test
    public void relative_path_for_case_insensitive_fs() throws IOException {
        Assume.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        PathResolver resolver = new PathResolver();
        File rootDir = this.temp.newFolder();
        File baseDir = new File(rootDir, "level1");
        File file = new File(baseDir, "../Level1/dir/file.c");
        Assertions.assertThat((String)resolver.relativePath(baseDir, file)).isEqualTo((Object)"dir/file.c");
    }

    @Test
    public void relative_path_from_multiple_dirs() throws IOException {
        PathResolver resolver = new PathResolver();
        File dir1 = this.temp.newFolder("D1");
        File dir2 = this.temp.newFolder("D2");
        File org = new File(dir2, "org");
        File hello = new File(org, "hello");
        File world = new File(hello, "World.java");
        PathResolver.RelativePath relativePath = resolver.relativePath(Arrays.asList(dir1, dir2), world);
        Assertions.assertThat((String)relativePath.dir().getCanonicalPath()).isEqualTo((Object)dir2.getCanonicalPath());
        Assertions.assertThat((String)relativePath.path()).isEqualTo((Object)"org/hello/World.java");
    }

    @Test
    public void relative_path_from_not_normalized_dirs() throws IOException {
        PathResolver resolver = new PathResolver();
        File rootDir = new File(this.temp.newFolder(), "foo/..");
        File org = new File(rootDir, "org");
        File hello = new File(org, "hello");
        File world = new File(hello, "World.java");
        PathResolver.RelativePath relativePath = resolver.relativePath(Arrays.asList(rootDir), world);
        Assertions.assertThat((Object)relativePath).isNotNull();
        Assertions.assertThat((File)relativePath.dir()).isEqualTo((Object)rootDir);
        Assertions.assertThat((String)relativePath.path()).isEqualTo((Object)"org/hello/World.java");
    }

    @Test
    public void cant_find_relative_path_from_multiple_dirs() throws IOException {
        PathResolver resolver = new PathResolver();
        File dir1 = this.temp.newFolder("D1");
        File dir2 = this.temp.newFolder("D2");
        File org = new File(dir2, "org");
        File hello = new File(org, "hello");
        File world = new File(hello, "World.java");
        PathResolver.RelativePath relativePath = resolver.relativePath(Arrays.asList(dir1), world);
        Assertions.assertThat((Object)relativePath).isNull();
    }

    @Test
    public void null_relative_path_when_file_is_not_in_dir() throws IOException {
        PathResolver resolver = new PathResolver();
        File rootDir = this.temp.newFolder();
        Assertions.assertThat((String)resolver.relativePath(rootDir, new File("Elsewhere.java"))).isNull();
    }

    @Test
    public void null_relative_path_when_file_is_not_in_dir2() throws IOException {
        PathResolver resolver = new PathResolver();
        File rootDir = this.temp.newFolder();
        Assertions.assertThat((String)resolver.relativePath(rootDir, new File(rootDir, "../Elsewhere.java"))).isNull();
    }

    @Test
    public void supportSymlink() {
        PathResolver resolver = new PathResolver();
        File rootDir = new File("src/test/resources/org/sonar/api/scan/filesystem/sample-with-symlink");
        Assertions.assertThat((String)resolver.relativePath(rootDir, new File("src/test/resources/org/sonar/api/scan/filesystem/sample-with-symlink/testx/ClassOneTest.java"))).isEqualTo((Object)"testx/ClassOneTest.java");
    }
}

