/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.scan.filesystem;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.config.MapSettings;
import org.sonar.api.config.Settings;
import org.sonar.api.scan.filesystem.FileExclusions;

public class FileExclusionsTest {
    @Test
    public void ignore_inclusion_of_world() {
        MapSettings settings = new MapSettings();
        settings.setProperty("sonar.inclusions", "**/*");
        settings.setProperty("sonar.test.inclusions", "**/*");
        Assertions.assertThat((Object[])new FileExclusions((Settings)settings).sourceInclusions()).isEmpty();
        Assertions.assertThat((Object[])new FileExclusions((Settings)settings).testInclusions()).isEmpty();
    }

    @Test
    public void load_inclusions() {
        MapSettings settings = new MapSettings();
        settings.setProperty("sonar.inclusions", "**/*Foo.java");
        settings.setProperty("sonar.test.inclusions", "**/*FooTest.java");
        FileExclusions moduleExclusions = new FileExclusions((Settings)settings);
        Assertions.assertThat((Object[])moduleExclusions.sourceInclusions()).containsOnly((Object[])new String[]{"**/*Foo.java"});
        Assertions.assertThat((Object[])moduleExclusions.testInclusions()).containsOnly((Object[])new String[]{"**/*FooTest.java"});
    }

    @Test
    public void load_exclusions() {
        MapSettings settings = new MapSettings();
        settings.setProperty("sonar.exclusions", "**/*Foo.java");
        settings.setProperty("sonar.test.exclusions", "**/*FooTest.java");
        FileExclusions moduleExclusions = new FileExclusions((Settings)settings);
        Assertions.assertThat((Object[])moduleExclusions.sourceInclusions()).isEmpty();
        Assertions.assertThat((Object[])moduleExclusions.sourceExclusions()).containsOnly((Object[])new String[]{"**/*Foo.java"});
        Assertions.assertThat((Object[])moduleExclusions.testInclusions()).isEmpty();
        Assertions.assertThat((Object[])moduleExclusions.testExclusions()).containsOnly((Object[])new String[]{"**/*FooTest.java"});
    }
}

