/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.rules.RuleType;

public class RuleTypeTest {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();

    @Test
    public void test_valueOf_db_constant() {
        Assertions.assertThat((Comparable)RuleType.valueOf((int)1)).isEqualTo((Object)RuleType.CODE_SMELL);
        Assertions.assertThat((Comparable)RuleType.valueOf((int)2)).isEqualTo((Object)RuleType.BUG);
    }

    @Test
    public void valueOf_throws_ISE_if_unsupported_db_constant() {
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage("Unsupported type value : 4");
        RuleType.valueOf((int)4);
    }

    @Test
    public void test_ALL_NAMES() {
        Assertions.assertThat((Iterable)RuleType.names()).containsOnly((Object[])new String[]{"BUG", "VULNERABILITY", "CODE_SMELL"});
    }

    @Test
    public void ALL_NAMES_is_immutable() {
        this.expectedException.expect(UnsupportedOperationException.class);
        RuleType.names().add("foo");
    }
}

