/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import java.util.Arrays;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.SonarException;

public class RuleTest {
    @Test
    public void description_should_be_cleaned() {
        Rule rule = Rule.create().setDescription("    my description         ");
        Assert.assertEquals((Object)"my description", (Object)rule.getDescription());
        rule.setDescription(null);
        Assertions.assertThat((String)rule.getDescription()).isNull();
    }

    @Test
    public void should_remove_new_line_characters_in_name_with_setter() {
        Rule rule = Rule.create();
        for (String example : this.getExamplesContainingNewLineCharacter()) {
            rule.setName(example);
            Assertions.assertThat((String)rule.getName()).isEqualTo((Object)"test");
        }
    }

    @Test
    public void should_remove_new_line_characters_in_name_with_first_constructor() {
        for (String example : this.getExamplesContainingNewLineCharacter()) {
            Rule rule = new Rule(null, null).setName(example);
            Assertions.assertThat((String)rule.getName()).isEqualTo((Object)"test");
        }
    }

    @Test
    public void should_remove_new_line_characters_in_name_with_second_constructor() {
        for (String example : this.getExamplesContainingNewLineCharacter()) {
            Rule rule = new Rule(null, null).setName(example);
            Assertions.assertThat((String)rule.getName()).isEqualTo((Object)"test");
        }
    }

    @Test
    public void default_priority_is_major() {
        Rule rule = Rule.create();
        Assertions.assertThat((Comparable)rule.getSeverity()).isEqualTo((Object)RulePriority.MAJOR);
        rule = new Rule("name", "key");
        Assertions.assertThat((Comparable)rule.getSeverity()).isEqualTo((Object)RulePriority.MAJOR);
        rule.setSeverity(RulePriority.BLOCKER);
        Assertions.assertThat((Comparable)rule.getSeverity()).isEqualTo((Object)RulePriority.BLOCKER);
        rule.setSeverity(null);
        Assertions.assertThat((Comparable)rule.getSeverity()).isEqualTo((Object)RulePriority.MAJOR);
    }

    @Test(expected=SonarException.class)
    public void should_not_authorize_unkown_status() {
        Rule.create().setStatus("Unknown");
    }

    @Test
    public void should_set_valid_status() {
        Rule rule = Rule.create().setStatus("DEPRECATED");
        Assertions.assertThat((String)rule.getStatus()).isEqualTo((Object)"DEPRECATED");
        rule = Rule.create().setStatus("REMOVED");
        Assertions.assertThat((String)rule.getStatus()).isEqualTo((Object)"REMOVED");
        rule = Rule.create().setStatus("BETA");
        Assertions.assertThat((String)rule.getStatus()).isEqualTo((Object)"BETA");
        rule = Rule.create().setStatus("READY");
        Assertions.assertThat((String)rule.getStatus()).isEqualTo((Object)"READY");
    }

    @Test
    public void testTags() {
        Rule rule = Rule.create();
        Assertions.assertThat((Object[])rule.getTags()).isEmpty();
        Assertions.assertThat((Object[])rule.getSystemTags()).isEmpty();
        rule.setTags(new String[]{"tag1", "tag2"});
        Assertions.assertThat((Object[])rule.getTags()).containsOnly((Object[])new String[]{"tag1", "tag2"});
        Assertions.assertThat((Object[])rule.getSystemTags()).isEmpty();
    }

    private List<String> getExamplesContainingNewLineCharacter() {
        return Arrays.asList("te\nst", "te\ns\nt", "te\rst", "te\n\rst", "te\r\nst");
    }
}

