/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rules;

import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.sonar.api.PropertyType;
import org.sonar.api.rules.AnnotationRuleParser;
import org.sonar.api.rules.Rule;
import org.sonar.api.rules.RuleParam;
import org.sonar.api.rules.RulePriority;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Priority;
import org.sonar.check.RuleProperty;

public class AnnotationRuleParserTest {
    @org.junit.Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void rule_with_property() {
        List<Rule> rules = this.parseAnnotatedClass(RuleWithProperty.class);
        Assertions.assertThat(rules).hasSize(1);
        Rule rule = rules.get(0);
        Assertions.assertThat((String)rule.getKey()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)rule.getName()).isEqualTo((Object)"bar");
        Assertions.assertThat((String)rule.getDescription()).isEqualTo((Object)"Foo Bar");
        Assertions.assertThat((Comparable)rule.getSeverity()).isEqualTo((Object)RulePriority.BLOCKER);
        Assertions.assertThat((String)rule.getStatus()).isEqualTo((Object)"READY");
        Assertions.assertThat((List)rule.getParams()).hasSize(1);
        RuleParam prop = rule.getParam("property");
        Assertions.assertThat((String)prop.getKey()).isEqualTo((Object)"property");
        Assertions.assertThat((String)prop.getDescription()).isEqualTo((Object)"Ignore ?");
        Assertions.assertThat((String)prop.getDefaultValue()).isEqualTo((Object)"false");
        Assertions.assertThat((String)prop.getType()).isEqualTo((Object)PropertyType.STRING.name());
    }

    @Test
    public void rule_with_integer_property() {
        List<Rule> rules = this.parseAnnotatedClass(RuleWithIntegerProperty.class);
        RuleParam prop = rules.get(0).getParam("property");
        Assertions.assertThat((String)prop.getDescription()).isEqualTo((Object)"Max");
        Assertions.assertThat((String)prop.getDefaultValue()).isEqualTo((Object)"12");
        Assertions.assertThat((String)prop.getType()).isEqualTo((Object)PropertyType.INTEGER.name());
    }

    @Test
    public void rule_with_text_property() {
        List<Rule> rules = this.parseAnnotatedClass(RuleWithTextProperty.class);
        RuleParam prop = rules.get(0).getParam("property");
        Assertions.assertThat((String)prop.getDescription()).isEqualTo((Object)"text");
        Assertions.assertThat((String)prop.getDefaultValue()).isEqualTo((Object)"Long text");
        Assertions.assertThat((String)prop.getType()).isEqualTo((Object)PropertyType.TEXT.name());
    }

    @Test
    public void should_reject_invalid_property_types() {
        this.exception.expect(SonarException.class);
        this.exception.expectMessage("Invalid property type [INVALID]");
        this.parseAnnotatedClass(RuleWithInvalidPropertyType.class);
    }

    @Test
    public void should_recognize_type() {
        Assertions.assertThat((Comparable)AnnotationRuleParser.guessType(Integer.class)).isEqualTo((Object)PropertyType.INTEGER);
        Assertions.assertThat((Comparable)AnnotationRuleParser.guessType(Integer.TYPE)).isEqualTo((Object)PropertyType.INTEGER);
        Assertions.assertThat((Comparable)AnnotationRuleParser.guessType(Float.class)).isEqualTo((Object)PropertyType.FLOAT);
        Assertions.assertThat((Comparable)AnnotationRuleParser.guessType(Float.TYPE)).isEqualTo((Object)PropertyType.FLOAT);
        Assertions.assertThat((Comparable)AnnotationRuleParser.guessType(Boolean.class)).isEqualTo((Object)PropertyType.BOOLEAN);
        Assertions.assertThat((Comparable)AnnotationRuleParser.guessType(Boolean.TYPE)).isEqualTo((Object)PropertyType.BOOLEAN);
        Assertions.assertThat((Comparable)AnnotationRuleParser.guessType(String.class)).isEqualTo((Object)PropertyType.STRING);
        Assertions.assertThat((Comparable)AnnotationRuleParser.guessType(Object.class)).isEqualTo((Object)PropertyType.STRING);
    }

    @Test
    public void rule_without_name_nor_description() {
        List<Rule> rules = this.parseAnnotatedClass(RuleWithoutNameNorDescription.class);
        Assertions.assertThat(rules).hasSize(1);
        Rule rule = rules.get(0);
        Assertions.assertThat((String)rule.getKey()).isEqualTo((Object)"foo");
        Assertions.assertThat((Comparable)rule.getSeverity()).isEqualTo((Object)RulePriority.MAJOR);
        Assertions.assertThat((String)rule.getName()).isNull();
        Assertions.assertThat((String)rule.getDescription()).isNull();
    }

    @Test
    public void rule_without_key() {
        List<Rule> rules = this.parseAnnotatedClass(RuleWithoutKey.class);
        Assertions.assertThat(rules).hasSize(1);
        Rule rule = rules.get(0);
        Assertions.assertThat((String)rule.getKey()).isEqualTo((Object)RuleWithoutKey.class.getCanonicalName());
        Assertions.assertThat((String)rule.getName()).isEqualTo((Object)"foo");
        Assertions.assertThat((String)rule.getDescription()).isNull();
        Assertions.assertThat((Comparable)rule.getSeverity()).isEqualTo((Object)RulePriority.MAJOR);
    }

    @Test
    public void overridden_rule() {
        List<Rule> rules = this.parseAnnotatedClass(OverridingRule.class);
        Assertions.assertThat(rules).hasSize(1);
        Rule rule = rules.get(0);
        Assertions.assertThat((String)rule.getKey()).isEqualTo((Object)"overriding_foo");
        Assertions.assertThat((String)rule.getName()).isEqualTo((Object)"Overriding Foo");
        Assertions.assertThat((String)rule.getDescription()).isNull();
        Assertions.assertThat((Comparable)rule.getSeverity()).isEqualTo((Object)RulePriority.MAJOR);
        Assertions.assertThat((List)rule.getParams()).hasSize(2);
    }

    private List<Rule> parseAnnotatedClass(Class annotatedClass) {
        return new AnnotationRuleParser().parse("repo", Collections.singleton(annotatedClass));
    }

    @org.sonar.check.Rule(key="foo", name="bar", description="Foo Bar", status="READY", priority=Priority.BLOCKER)
    static class RuleWithInvalidPropertyType {
        @RuleProperty(description="text", defaultValue="Long text", type="INVALID")
        public String property;

        RuleWithInvalidPropertyType() {
        }
    }

    @org.sonar.check.Rule(key="foo", name="bar", description="Foo Bar", status="READY", priority=Priority.BLOCKER)
    static class RuleWithTextProperty {
        @RuleProperty(description="text", defaultValue="Long text", type="TEXT")
        protected String property;

        RuleWithTextProperty() {
        }
    }

    @org.sonar.check.Rule(key="foo", name="bar", description="Foo Bar", status="READY", priority=Priority.BLOCKER)
    static class RuleWithIntegerProperty {
        @RuleProperty(description="Max", defaultValue="12")
        private Integer property;

        RuleWithIntegerProperty() {
        }
    }

    @org.sonar.check.Rule(key="overriding_foo", name="Overriding Foo")
    static class OverridingRule
    extends RuleWithProperty {
        @RuleProperty
        private String additionalProperty;

        OverridingRule() {
        }
    }

    @org.sonar.check.Rule(key="foo", name="bar", description="Foo Bar", status="READY", priority=Priority.BLOCKER)
    static class RuleWithProperty {
        @RuleProperty(description="Ignore ?", defaultValue="false")
        private String property;

        RuleWithProperty() {
        }
    }

    @org.sonar.check.Rule(key="foo")
    static class RuleWithoutNameNorDescription {
        RuleWithoutNameNorDescription() {
        }
    }

    @org.sonar.check.Rule(name="foo")
    static class RuleWithoutKey {
        RuleWithoutKey() {
        }
    }
}

