/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.rule;

import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.rule.RuleKey;

public class RuleKeyTest {
    @Test
    public void testOf() throws Exception {
        RuleKey key = RuleKey.of((String)"squid", (String)"NullDeref");
        Assertions.assertThat((String)key.repository()).isEqualTo((Object)"squid");
        Assertions.assertThat((String)key.rule()).isEqualTo((Object)"NullDeref");
    }

    @Test
    public void key_can_contain_colons() {
        RuleKey key = RuleKey.of((String)"squid", (String)"Key:With:Some::Colons");
        Assertions.assertThat((String)key.repository()).isEqualTo((Object)"squid");
        Assertions.assertThat((String)key.rule()).isEqualTo((Object)"Key:With:Some::Colons");
    }

    @Test
    public void repository_must_not_be_null() {
        try {
            RuleKey.of(null, (String)"NullDeref");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Repository must be set");
        }
    }

    @Test
    public void repository_must_not_be_empty() {
        try {
            RuleKey.of((String)"", (String)"NullDeref");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Repository must be set");
        }
    }

    @Test
    public void rule_must_not_be_null() {
        try {
            RuleKey.of((String)"squid", null);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Rule must be set");
        }
    }

    @Test
    public void rule_must_not_be_empty() {
        try {
            RuleKey.of((String)"squid", (String)"");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Rule must be set");
        }
    }

    @Test
    public void encode_and_decode_string() {
        RuleKey key = RuleKey.of((String)"squid", (String)"NullDeref");
        String serialized = key.toString();
        Assertions.assertThat((String)serialized).isEqualTo((Object)"squid:NullDeref");
        RuleKey parsed = RuleKey.parse((String)serialized);
        Assertions.assertThat((String)parsed.repository()).isEqualTo((Object)"squid");
        Assertions.assertThat((String)parsed.rule()).isEqualTo((Object)"NullDeref");
        Assertions.assertThat((String)parsed.toString()).isEqualTo((Object)"squid:NullDeref");
    }

    @Test
    public void parse_key_with_colons() {
        RuleKey key = RuleKey.parse((String)"squid:Key:With:Some::Colons");
        Assertions.assertThat((String)key.repository()).isEqualTo((Object)"squid");
        Assertions.assertThat((String)key.rule()).isEqualTo((Object)"Key:With:Some::Colons");
    }

    @Test
    public void not_accept_bad_format() {
        try {
            RuleKey.parse((String)"foo");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assertions.assertThat((Throwable)e).hasMessage("Invalid rule key: foo");
        }
    }

    @Test
    public void test_equals_and_hashcode() throws Exception {
        RuleKey key1 = RuleKey.of((String)"squid", (String)"NullDeref");
        RuleKey key2 = RuleKey.of((String)"squid", (String)"NullDeref");
        RuleKey key3 = RuleKey.of((String)"squid", (String)"Other");
        Assertions.assertThat((Comparable)key1).isEqualTo((Object)key1);
        Assertions.assertThat((Comparable)key1).isEqualTo((Object)key2);
        Assertions.assertThat((Comparable)key1).isNotEqualTo((Object)key3);
        Assertions.assertThat((Comparable)key1).isNotEqualTo(null);
        Assertions.assertThat((int)key1.hashCode()).isEqualTo(key1.hashCode());
        Assertions.assertThat((int)key1.hashCode()).isEqualTo(key2.hashCode());
    }

    @Test
    public void test_compareTo() {
        RuleKey aa = RuleKey.of((String)"A", (String)"A");
        RuleKey ab = RuleKey.of((String)"A", (String)"B");
        Assertions.assertThat((Comparable)ab).isGreaterThan((Comparable)aa);
        Assertions.assertThat((Comparable)aa).isLessThan((Comparable)ab);
        Assertions.assertThat((Comparable)aa).isNotEqualTo((Object)ab);
        Assertions.assertThat((Comparable)ab).isNotEqualTo((Object)aa);
        Assertions.assertThat((Comparable)aa).isEqualTo((Object)aa);
        Assertions.assertThat((Comparable)ab).isEqualTo((Object)ab);
    }
}

