/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.batch.bootstrap.ProjectDefinition;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.Scopes;

public class ScopesTest {
    @Test
    public void testProject() {
        Project resource = new Project(ProjectDefinition.create());
        Assert.assertThat((Object)Scopes.isProject((Resource)resource), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Scopes.isDirectory((Resource)resource), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isFile((Resource)resource), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isBlockUnit((Resource)resource), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isProgramUnit((Resource)resource), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testDirectory() {
        Directory resource = Directory.create((String)"org/foo");
        Assert.assertThat((Object)Scopes.isProject((Resource)resource), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isDirectory((Resource)resource), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Scopes.isFile((Resource)resource), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isBlockUnit((Resource)resource), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isProgramUnit((Resource)resource), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testFile() {
        File resource = File.create((String)"org/foo/Bar.java");
        Assert.assertThat((Object)Scopes.isProject((Resource)resource), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isDirectory((Resource)resource), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isFile((Resource)resource), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Scopes.isBlockUnit((Resource)resource), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isProgramUnit((Resource)resource), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void shouldBeHigherThan() {
        Assert.assertThat((Object)Scopes.isHigherThan((String)"PRJ", (String)"PRJ"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isHigherThan((String)"PRJ", (String)"DIR"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Scopes.isHigherThan((String)"PRJ", (String)"BLU"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Scopes.isHigherThan((String)"FIL", (String)"FIL"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isHigherThan((String)"FIL", (String)"DIR"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isHigherThan((String)"FIL", (String)"BLU"), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void shouldBeHigherThanOrEquals() {
        Assert.assertThat((Object)Scopes.isHigherThanOrEquals((String)"PRJ", (String)"PRJ"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Scopes.isHigherThanOrEquals((String)"PRJ", (String)"DIR"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Scopes.isHigherThanOrEquals((String)"PRJ", (String)"BLU"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Scopes.isHigherThanOrEquals((String)"FIL", (String)"FIL"), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)Scopes.isHigherThanOrEquals((String)"FIL", (String)"DIR"), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)Scopes.isHigherThanOrEquals((String)"FIL", (String)"BLU"), (Matcher)Matchers.is((Object)true));
    }
}

