/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;
import org.sonar.api.resources.Directory;
import org.sonar.api.resources.File;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.ResourceUtils;

public class ResourceUtilsTest {
    @Test
    public void checkFile() {
        File file = File.create((String)"hello.Foo");
        Assertions.assertThat((boolean)ResourceUtils.isModuleProject((Resource)file)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isSpace((Resource)file)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isEntity((Resource)file)).isTrue();
        Assertions.assertThat((boolean)ResourceUtils.isSet((Resource)file)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isRootProject((Resource)file)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isUnitTestClass((Resource)file)).isFalse();
    }

    @Test
    public void checkUnitTest() {
        File utFile = File.create((String)"hello.Foo");
        utFile.setQualifier("UTS");
        Assertions.assertThat((boolean)ResourceUtils.isModuleProject((Resource)utFile)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isSpace((Resource)utFile)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isEntity((Resource)utFile)).isTrue();
        Assertions.assertThat((boolean)ResourceUtils.isSet((Resource)utFile)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isRootProject((Resource)utFile)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isUnitTestClass((Resource)utFile)).isTrue();
    }

    @Test
    public void checkDirectory() {
        Directory dir = Directory.create((String)"hello");
        Assertions.assertThat((boolean)ResourceUtils.isModuleProject((Resource)dir)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isSpace((Resource)dir)).isTrue();
        Assertions.assertThat((boolean)ResourceUtils.isEntity((Resource)dir)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isSet((Resource)dir)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isRootProject((Resource)dir)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isUnitTestClass((Resource)dir)).isFalse();
    }

    @Test
    public void shouldBePersistable() {
        Assertions.assertThat((boolean)ResourceUtils.isPersistable((Resource)File.create((String)"Foo.java"))).isTrue();
        Assertions.assertThat((boolean)ResourceUtils.isPersistable((Resource)Directory.create((String)"bar/Foo.java"))).isTrue();
    }

    @Test
    public void shouldNotBePersistable() {
        Resource javaClass = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)javaClass.getScope()).thenReturn((Object)"PGU");
        Resource javaMethod = (Resource)Mockito.mock(Resource.class);
        Mockito.when((Object)javaMethod.getScope()).thenReturn((Object)"BLU");
        Assertions.assertThat((boolean)ResourceUtils.isPersistable((Resource)javaClass)).isFalse();
        Assertions.assertThat((boolean)ResourceUtils.isPersistable((Resource)javaMethod)).isFalse();
    }
}

