/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypeTree;
import org.sonar.api.resources.ResourceTypes;

public class ResourceTypesTest {
    private ResourceTypeTree viewsTree = ResourceTypeTree.builder().addType(ResourceType.builder((String)"VW").setProperty("supportsMeasureFilters", "true").build()).addType(ResourceType.builder((String)"SVW").build()).addRelations("VW", new String[]{"SVW"}).addRelations("SVW", new String[]{"TRK"}).build();
    private ResourceTypeTree defaultTree = ResourceTypeTree.builder().addType(ResourceType.builder((String)"TRK").setProperty("supportsMeasureFilters", "true").build()).addType(ResourceType.builder((String)"DIR").build()).addType(ResourceType.builder((String)"FIL").build()).addRelations("TRK", new String[]{"DIR"}).addRelations("DIR", new String[]{"FIL"}).build();
    private ResourceTypes types = new ResourceTypes(new ResourceTypeTree[]{this.defaultTree, this.viewsTree});

    @Test
    public void get() {
        Assertions.assertThat((String)this.types.get("TRK").getQualifier()).isEqualTo((Object)"TRK");
        Assertions.assertThat((String)this.types.get("xxx").getQualifier()).isEqualTo((Object)"xxx");
    }

    @Test
    public void get_all() {
        Assertions.assertThat(ResourceTypesTest.qualifiers(this.types.getAll())).containsExactly((Object[])new String[]{"TRK", "DIR", "FIL", "VW", "SVW"});
    }

    @Test
    public void get_all_ordered() {
        Assertions.assertThat(ResourceTypesTest.qualifiers(this.types.getAllOrdered())).containsExactly((Object[])new String[]{"VW", "SVW", "TRK", "DIR", "FIL"});
    }

    @Test
    public void get_roots() {
        Assertions.assertThat(ResourceTypesTest.qualifiers(this.types.getRoots())).containsOnly((Object[])new String[]{"TRK", "VW"});
    }

    @Test
    public void get_all_predicate() {
        Collection forFilters = this.types.getAll(ResourceTypes.AVAILABLE_FOR_FILTERS);
        Assertions.assertThat(ResourceTypesTest.qualifiers(forFilters)).containsOnly((Object[])new String[]{"TRK", "VW"}).doesNotHaveDuplicates();
    }

    @Test
    public void get_all_with_property_key() {
        Assertions.assertThat(ResourceTypesTest.qualifiers(this.types.getAllWithPropertyKey("supportsMeasureFilters"))).containsOnly((Object[])new String[]{"VW", "TRK"});
    }

    @Test
    public void get_all_with_property_value() {
        Assertions.assertThat(ResourceTypesTest.qualifiers(this.types.getAllWithPropertyValue("supportsMeasureFilters", "true"))).containsOnly((Object[])new String[]{"VW", "TRK"});
        Assertions.assertThat(ResourceTypesTest.qualifiers(this.types.getAllWithPropertyValue("supportsMeasureFilters", true))).containsOnly((Object[])new String[]{"VW", "TRK"});
        Assertions.assertThat(ResourceTypesTest.qualifiers(this.types.getAllWithPropertyValue("supportsMeasureFilters", false))).containsOnly((Object[])new String[]{"SVW", "DIR", "FIL"});
    }

    @Test
    public void get_children_qualifiers() {
        Assertions.assertThat((List)this.types.getChildrenQualifiers("TRK")).containsExactly((Object[])new String[]{"DIR"});
        Assertions.assertThat((List)this.types.getChildrenQualifiers("SVW")).containsExactly((Object[])new String[]{"TRK"});
        Assertions.assertThat((List)this.types.getChildrenQualifiers("xxx")).isEmpty();
        Assertions.assertThat((List)this.types.getChildrenQualifiers("FIL")).isEmpty();
    }

    @Test
    public void get_children() {
        Assertions.assertThat(ResourceTypesTest.qualifiers(this.types.getChildren("TRK"))).contains((Object[])new String[]{"DIR"});
        Assertions.assertThat(ResourceTypesTest.qualifiers(this.types.getChildren("SVW"))).contains((Object[])new String[]{"TRK"});
    }

    @Test
    public void get_leaves_qualifiers() {
        Assertions.assertThat((List)this.types.getLeavesQualifiers("TRK")).containsExactly((Object[])new String[]{"FIL"});
        Assertions.assertThat((List)this.types.getLeavesQualifiers("DIR")).containsExactly((Object[])new String[]{"FIL"});
        Assertions.assertThat((List)this.types.getLeavesQualifiers("VW")).containsExactly((Object[])new String[]{"TRK"});
        Assertions.assertThat((List)this.types.getLeavesQualifiers("xxx")).isEmpty();
    }

    @Test
    public void get_tree() {
        Assertions.assertThat(ResourceTypesTest.qualifiers(this.types.getTree("VW").getTypes())).containsOnly((Object[])new String[]{"VW", "SVW"}).doesNotHaveDuplicates();
        Assertions.assertThat((Object)this.types.getTree("xxx")).isNull();
    }

    @Test
    public void get_root() {
        Assertions.assertThat((String)this.types.getRoot("FIL").getQualifier()).isEqualTo((Object)"TRK");
    }

    @Test(expected=IllegalStateException.class)
    public void fail_on_duplicated_qualifier() {
        ResourceTypeTree tree1 = ResourceTypeTree.builder().addType(ResourceType.builder((String)"foo").build()).build();
        ResourceTypeTree tree2 = ResourceTypeTree.builder().addType(ResourceType.builder((String)"foo").build()).build();
        new ResourceTypes(new ResourceTypeTree[]{tree1, tree2});
    }

    static Collection<String> qualifiers(Collection<ResourceType> types) {
        return Collections2.transform(types, (Function)new Function<ResourceType, String>(){

            public String apply(ResourceType type) {
                return type.getQualifier();
            }
        });
    }
}

