/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypeTree;
import org.sonar.api.resources.ResourceTypesTest;

public class ResourceTypeTreeTest {
    private final ResourceTypeTree tree = ResourceTypeTree.builder().addType(ResourceType.builder((String)"TRK").build()).addType(ResourceType.builder((String)"DIR").build()).addType(ResourceType.builder((String)"FIL").build()).addType(ResourceType.builder((String)"UTS").build()).addRelations("TRK", new String[]{"DIR"}).addRelations("DIR", new String[]{"FIL"}).addRelations("DIR", new String[]{"UTS"}).build();

    @Test
    public void getTypes() {
        Assert.assertThat((Object)this.tree.getTypes().size(), (Matcher)Is.is((Object)4));
        Assert.assertThat(ResourceTypesTest.qualifiers(this.tree.getTypes()), (Matcher)Matchers.hasItems((Object[])new String[]{"TRK", "DIR", "FIL", "UTS"}));
    }

    @Test
    public void getChildren() {
        Assert.assertThat((Object)this.tree.getChildren("TRK").size(), (Matcher)Is.is((Object)1));
        Assert.assertThat((Object)this.tree.getChildren("TRK"), (Matcher)Matchers.hasItems((Object[])new String[]{"DIR"}));
        Assert.assertThat((Object)this.tree.getChildren("DIR").size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.tree.getChildren("DIR"), (Matcher)Matchers.hasItems((Object[])new String[]{"FIL", "UTS"}));
        Assert.assertThat((Object)this.tree.getChildren("FIL").size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void getRoot() {
        Assert.assertThat((Object)this.tree.getRootType(), (Matcher)Is.is((Object)ResourceType.builder((String)"TRK").build()));
    }

    @Test
    public void getLeaves() {
        Assert.assertThat((Object)this.tree.getLeaves().size(), (Matcher)Is.is((Object)2));
        Assert.assertThat((Object)this.tree.getLeaves(), (Matcher)Matchers.hasItems((Object[])new String[]{"FIL", "UTS"}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void forbidNullRelation() {
        ResourceTypeTree.builder().addType(ResourceType.builder((String)"TRK").build()).addType(ResourceType.builder((String)"DIR").build()).addRelations("DIR", new String[0]).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void forbidDuplicatedType() {
        ResourceTypeTree.builder().addType(ResourceType.builder((String)"TRK").build()).addType(ResourceType.builder((String)"TRK").build()).build();
    }
}

