/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.sonar.api.resources.ResourceType;

public class ResourceTypeTest {
    @Test
    public void shouldCreateWithDefaults() {
        ResourceType def = ResourceType.builder((String)"qualifier").build();
        Assertions.assertThat((String)def.getQualifier()).isEqualTo((Object)"qualifier");
        Assertions.assertThat((String)def.getIconPath()).isEqualTo((Object)"/images/q/qualifier.png");
        Assertions.assertThat((boolean)def.hasSourceCode()).isFalse();
    }

    @Test
    public void shouldCreate() {
        ResourceType def = ResourceType.builder((String)"qualifier").setIconPath("/custom-icon.png").hasSourceCode().setProperty("supportsMeasureFilters", "true").setProperty("anotherProperty", "foo").build();
        Assertions.assertThat((String)def.getQualifier()).isEqualTo((Object)"qualifier");
        Assertions.assertThat((String)def.getIconPath()).isEqualTo((Object)"/custom-icon.png");
        Assertions.assertThat((boolean)def.hasSourceCode()).isTrue();
        Assertions.assertThat((String)def.getStringProperty("anotherProperty")).isEqualTo((Object)"foo");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldCheckQualifierLength() {
        ResourceType.builder((String)"qualifier bigger than 10 characters");
    }

    @Test
    public void testEqualsAndHashCode() {
        ResourceType foo1 = ResourceType.builder((String)"FOO").build();
        ResourceType foo2 = ResourceType.builder((String)"FOO").build();
        ResourceType bar = ResourceType.builder((String)"BAR").build();
        Assertions.assertThat((boolean)foo1.equals((Object)foo1)).isTrue();
        Assertions.assertThat((boolean)foo1.equals((Object)foo2)).isTrue();
        Assertions.assertThat((boolean)foo1.equals((Object)bar)).isFalse();
        Assertions.assertThat((int)foo1.hashCode()).isEqualTo(foo1.hashCode());
    }

    @Test
    public void getBooleanProperty_is_set() {
        ResourceType def = ResourceType.builder((String)"qualifier").setProperty("test", true).build();
        Assertions.assertThat((boolean)def.getBooleanProperty("test")).isTrue();
        def = ResourceType.builder((String)"qualifier").setProperty("test", false).build();
        Assertions.assertThat((boolean)def.getBooleanProperty("test")).isFalse();
        def = ResourceType.builder((String)"qualifier").setProperty("test", "true").build();
        Assertions.assertThat((boolean)def.getBooleanProperty("test")).isTrue();
        def = ResourceType.builder((String)"qualifier").setProperty("test", "false").build();
        Assertions.assertThat((boolean)def.getBooleanProperty("test")).isFalse();
    }

    @Test
    public void getBooleanProperty_is_not_set() {
        ResourceType def = ResourceType.builder((String)"qualifier").build();
        Assertions.assertThat((boolean)def.getBooleanProperty("test")).isFalse();
    }

    @Test
    public void hasProperty() {
        ResourceType def = ResourceType.builder((String)"qualifier").build();
        Assertions.assertThat((boolean)def.hasProperty("foo")).isFalse();
        def = ResourceType.builder((String)"qualifier").setProperty("foo", "bar").build();
        Assertions.assertThat((boolean)def.hasProperty("foo")).isTrue();
    }
}

